/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.xnet.client;

import com.evps.comm.local.config.ApplicationConfig;
import com.evps.comm.local.dto.CenterDto;
import com.evps.comm.local.repository.ApplicationRepository;
import com.evps.comm.local.xnet.client.EvpsLocalClientBootstrapFactory;
import com.evps.comm.local.xnet.client.codec.EvpsLocalClientEncoder;
import com.evps.comm.local.xnet.client.handler.EvpsLocalClientPacketInboundHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvpsLocalClient
implements Callable<Object> {
    private static final Logger log = LoggerFactory.getLogger(EvpsLocalClient.class);
    private final CenterDto center;
    private final ApplicationConfig config;
    private final EvpsLocalClientBootstrapFactory bootstrapFactory;
    private final EvpsLocalClientPacketInboundHandler evpsLocalClientPacketInboundHandler;
    private final EvpsLocalClientEncoder evpsLocalClientEncoder;
    private Bootstrap bootstrap = null;
    private ChannelFuture channelFuture = null;
    private String ipAddress;
    private int port;

    @Override
    public Object call() {
        this.ipAddress = this.center.getIpAddress();
        this.port = this.center.getCommPort();
        log.info("EvpsLocalClient Start: [{}, {}], {}", new Object[]{this.center.getCenterId(), this.ipAddress, this.port});
        if (this.bootstrap == null) {
            this.bootstrap = this.bootstrapFactory.createBootstrap();
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(this.config.getConnectionTimeout() * 1000));
            this.bootstrap.handler((ChannelHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
        log.info("EvpsLocalClient Connect Try: [{}, {}], {}", new Object[]{this.center.getCenterId(), this.ipAddress, this.port});
        if (this.channelFuture != null && this.channelFuture.channel() != null) {
            this.channelFuture.channel().close();
            this.channelFuture = null;
        }
        this.channelFuture = this.bootstrap.connect((SocketAddress)new InetSocketAddress(this.ipAddress, this.port));
        this.channelFuture.addListener((GenericFutureListener)new /* Unavailable Anonymous Inner Class!! */);
        this.channelFuture.channel().closeFuture().addListener((GenericFutureListener)new /* Unavailable Anonymous Inner Class!! */);
        return null;
    }

    protected void channelOpen(Channel channel) {
        log.info("EvpsLocalClient Connect Success. [{}, {}], {}, Channel: {}", new Object[]{this.center.getCenterId(), this.center.getIpAddress(), this.center.getCommPort(), channel});
        ApplicationRepository.setCenterObject((Channel)channel, (CenterDto)this.center);
        this.center.getNetState().connect(channel);
    }

    protected synchronized void channelClosed(Channel channel) {
        log.warn("EvpsLocalClient Connect Closed. [{}, {}], {}, Channel: {}", new Object[]{this.center.getCenterId(), this.center.getIpAddress(), this.center.getCommPort(), channel});
        ApplicationRepository.setCenterObject((Channel)channel, null);
        this.center.getNetState().disConnect();
        channel.close();
        channel.eventLoop().schedule((Callable)this, (long)this.config.getRetryConnectSeconds(), TimeUnit.SECONDS);
    }

    public CenterDto getCenter() {
        return this.center;
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public EvpsLocalClientBootstrapFactory getBootstrapFactory() {
        return this.bootstrapFactory;
    }

    public EvpsLocalClientPacketInboundHandler getEvpsLocalClientPacketInboundHandler() {
        return this.evpsLocalClientPacketInboundHandler;
    }

    public EvpsLocalClientEncoder getEvpsLocalClientEncoder() {
        return this.evpsLocalClientEncoder;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setBootstrap(Bootstrap bootstrap) {
        this.bootstrap = bootstrap;
    }

    public void setChannelFuture(ChannelFuture channelFuture) {
        this.channelFuture = channelFuture;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public EvpsLocalClient(CenterDto center, ApplicationConfig config, EvpsLocalClientBootstrapFactory bootstrapFactory, EvpsLocalClientPacketInboundHandler evpsLocalClientPacketInboundHandler, EvpsLocalClientEncoder evpsLocalClientEncoder) {
        this.center = center;
        this.config = config;
        this.bootstrapFactory = bootstrapFactory;
        this.evpsLocalClientPacketInboundHandler = evpsLocalClientPacketInboundHandler;
        this.evpsLocalClientEncoder = evpsLocalClientEncoder;
    }

    static /* synthetic */ CenterDto access$000(EvpsLocalClient x0) {
        return x0.center;
    }

    static /* synthetic */ EvpsLocalClientPacketInboundHandler access$100(EvpsLocalClient x0) {
        return x0.evpsLocalClientPacketInboundHandler;
    }

    static /* synthetic */ EvpsLocalClientEncoder access$200(EvpsLocalClient x0) {
        return x0.evpsLocalClientEncoder;
    }

    static /* synthetic */ Logger access$300() {
        return log;
    }
}

