/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.xnet.client.process.request;

import com.evps.comm.local.xnet.client.process.request.EvpsFrameData;
import com.evps.common.kafka.dto.KafkaEvpsEventDto;
import com.evps.common.protocol.eEvpsOpCode;
import com.its.common.utils.ByteUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EvpsEvent
extends EvpsFrameData {
    public EvpsEvent(KafkaEvpsEventDto event) {
        super(eEvpsOpCode.EVPS_EVENT.getValue(), event.getServiceId());
        int bodySize = 26;
        this.body = ByteBuffer.allocate(bodySize);
        this.body.order(ByteOrder.BIG_ENDIAN);
        this.setLength(bodySize);
        byte[] evNoArr = new byte[10];
        ByteUtils.copyStringToByteArray((byte[])evNoArr, (String)event.getEvNo());
        this.body.put(evNoArr);
        this.body.putInt((int)(event.getCurLat() * 1000000.0));
        this.body.putInt((int)(event.getCurLng() * 1000000.0));
        this.body.putInt(event.getCurSpd());
        this.body.putInt(event.getRemDist());
    }

    public String getMsgType() {
        return "EvpsEvent";
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer frame = ByteBuffer.allocate(this.getHeadSize() + this.getBodySize());
        frame.put(this.getHeadBuffer().array());
        frame.put(this.getBodyBuffer().array());
        return frame;
    }
}

