/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server;

import com.evps.comm.server.config.TraceConfig;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.comm.server.xnet.server.EvpsCommServerService;
import com.evps.comm.server.xnet.server.process.work.DataPacketProcess;
import com.its.common.spring.SpringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@EnableTransactionManagement
@ComponentScan(basePackages={"com.its.common.spring", "com.evps.comm.server.config", "com.evps.comm.server"})
public class EvpsCommServerApplication
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(EvpsCommServerApplication.class);
    private static final String APPLICATION_NAME = "evps-comm-server";

    public static void main(String[] args) {
        SpringApplication application = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{EvpsCommServerApplication.class}).listeners(new ApplicationListener[]{new ApplicationPidFileWriter("./conf/evps-comm-server.pid")}).build();
        application.setBannerMode(Banner.Mode.OFF);
        application.run(args);
    }

    public void run(String ... args) throws Exception {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info("");
        log.info("");
        log.info("************************************************************************************");
        log.info("**                                                                                **");
        log.info("**                            UTIC Signal System                                  **");
        log.info("**     UTIC Emergency Vehicle Preemption System Communication Server Program.     **");
        log.info("**                                                                                **");
        log.info("**                                                                   [ver.1.0]    **");
        log.info("** startup: {}", (Object)sdfDate.format(new Date()));
        log.info("************************************************************************************");
        DbmsDataProcess dbmsDataProcess = (DbmsDataProcess)SpringUtils.getBean(DbmsDataProcess.class);
        dbmsDataProcess.run();
        DataPacketProcess dataPacketProcess = (DataPacketProcess)SpringUtils.getBean(DataPacketProcess.class);
        dataPacketProcess.run();
        ApplicationRepository applicationRepository = (ApplicationRepository)SpringUtils.getBean(ApplicationRepository.class);
        applicationRepository.loadDb();
        applicationRepository.loadServices();
        applicationRepository.initEvpsCenterStts();
        TraceConfig traceConfig = (TraceConfig)SpringUtils.getBean(TraceConfig.class);
        traceConfig.loadTraceInfo();
        EvpsCommServerService evpsCommServerService = (EvpsCommServerService)SpringUtils.getBean(EvpsCommServerService.class);
        evpsCommServerService.run();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.error("on shutdown hook.");
            this.terminate();
        }));
    }

    public void terminate() {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.error("************************************************************************************");
        log.error("**    Application Terminated: {}", (Object)sdfDate.format(new Date()));
        EvpsCommServerService cvimServer = (EvpsCommServerService)SpringUtils.getBean(EvpsCommServerService.class);
        try {
            cvimServer.stop();
        }
        catch (Exception e) {
            log.error("**    onApplicationEvent Exception: {}", (Object)e.getMessage());
        }
        log.error("************************************************************************************");
    }

    public void onApplicationEvent(ContextClosedEvent contextClosedEvent) {
        log.error("{}", (Object)contextClosedEvent);
        this.terminate();
    }

    public void destroy() throws Exception {
        log.error("Application destroy.");
    }

    public void afterPropertiesSet() throws Exception {
        log.info("Application afterPropertiesSet.");
    }
}

