/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.xnet.server.process.response;

import com.evps.comm.server.kafka.KafkaProducerService;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.protocol.response.EvpsCommResponse;
import com.evps.common.protocol.response.RecvPacketDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvpsNetPing
implements EvpsCommResponse {
    private static final Logger log = LoggerFactory.getLogger(EvpsNetPing.class);
    private final DbmsDataProcess dbmsDataProcess;
    private final KafkaProducerService kafkaProducerService;

    public boolean response(RecvPacketDto packet) {
        boolean result = true;
        try {
            log.info("[{}]. EvpsNetPing.response. Service Id: {}.", (Object)packet.getCenter().getLogKey(), (Object)packet.getPacket().getServiceId());
            return this.makeData(packet, packet.getPacket().getBuffer());
        }
        catch (Exception e) {
            log.error("[{}]. EvpsNetPing.response: Service Id: {}, Exception. will be closed. {}", new Object[]{packet.getCenter().getLogKey(), packet.getPacket().getServiceId(), e.getMessage()});
            result = false;
            return result;
        }
    }

    private boolean makeData(RecvPacketDto packet, byte[] buffer) {
        EvpsCenter center = packet.getCenter();
        if (buffer == null || buffer.length != 4) {
            log.error("[{}]. EvpsNetPing.response: Service Id: {}, Data Length Error: Required data length({}), Cur({}). will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), 4, buffer == null ? 0 : buffer.length});
            return false;
        }
        int idx = 0;
        long sequenceNumber = (long)(buffer[idx++] & 0xFF) << 24 | (long)((buffer[idx++] & 0xFF) << 16) | (long)((buffer[idx++] & 0xFF) << 8) | (long)(buffer[idx++] & 0xFF);
        log.info("[{}]. EvpsNetPing.response: Service Id: {}, SequenceNumber: {}", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), sequenceNumber});
        return true;
    }

    public EvpsNetPing(DbmsDataProcess dbmsDataProcess, KafkaProducerService kafkaProducerService) {
        this.dbmsDataProcess = dbmsDataProcess;
        this.kafkaProducerService = kafkaProducerService;
    }
}

