/*
 * Decompiled with CFR 0.152.
 */
package com.evps.consumer.service;

import com.evps.consumer.dto.EvpsEventDto;
import com.evps.consumer.dto.EvpsNodeDto;
import com.evps.consumer.dto.EvpsServiceDto;
import com.evps.consumer.dto.EvpsServiceEndDto;
import com.evps.consumer.dto.EvpsSignalDto;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.MessageListener;

public class KafkaUticEvpsConsumerWorker
implements MessageListener<String, String> {
    private static final Logger log = LoggerFactory.getLogger(KafkaUticEvpsConsumerWorker.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public void onMessage(ConsumerRecord<String, String> record) {
        log.info("onMessage: Key: {}, Data: {}", record.key(), record.value());
        try {
            if ("evps-event".equals(record.key())) {
                EvpsEventDto data = (EvpsEventDto)mapper.readValue((String)record.value(), EvpsEventDto.class);
                log.info("---EvpsEvent: {}", (Object)data);
            } else if ("evps-signal".equals(record.key())) {
                EvpsSignalDto data = (EvpsSignalDto)mapper.readValue((String)record.value(), EvpsSignalDto.class);
                log.info("--EvpsSignal: {}", (Object)data);
            } else if ("evps-node".equals(record.key())) {
                EvpsNodeDto data = (EvpsNodeDto)mapper.readValue((String)record.value(), EvpsNodeDto.class);
                log.info("----EvpsNode: {}", (Object)data);
            } else if ("evps-service".equals(record.key())) {
                EvpsServiceDto data = (EvpsServiceDto)mapper.readValue((String)record.value(), EvpsServiceDto.class);
                log.info("-EvpsService: {}", (Object)data);
            } else if ("evps-service-end".equals(record.key())) {
                EvpsServiceEndDto data = (EvpsServiceEndDto)mapper.readValue((String)record.value(), EvpsServiceEndDto.class);
                log.info("-EvpsServiceEnd: {}", (Object)data);
            } else {
                log.error("Unknown Utic Evps Kafka Key: {}, {}", record.key(), record.value());
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

