/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.config;

import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.common.dto.EvpsCenter;
import com.its.common.utils.StringUtils;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TraceConfig {
    private static final Logger log = LoggerFactory.getLogger(TraceConfig.class);
    private final ApplicationRepository repo;

    private Properties getProperties() {
        String workingDir = System.getProperty("user.dir");
        Properties props = new Properties();
        try {
            FileInputStream in = new FileInputStream(workingDir + "/conf/evps-comm-server-trace.cfg");
            props.load(in);
            in.close();
        }
        catch (Exception e) {
            log.error("{}.getProperties Exception: {}", (Object)this.getClass().getSimpleName(), (Object)e.toString());
        }
        return props;
    }

    public void loadTraceInfo() {
        try {
            this.repo.getCenterMap().forEach((key, center) -> center.setDump(false));
            Properties props = this.getProperties();
            String dumps = props.getProperty("DUMP", "").trim();
            if (dumps.isEmpty()) {
                return;
            }
            List regionCds = StringUtils.split((String)dumps, (String)",");
            regionCds.forEach(id -> {
                EvpsCenter center = (EvpsCenter)this.repo.getCenterMap().get(id.trim());
                if (center != null) {
                    center.setDump(true);
                }
            });
        }
        catch (Exception e) {
            log.error("{}.loadTraceInfo Exception: {}", (Object)this.getClass().getSimpleName(), (Object)e.toString());
        }
    }

    public ApplicationRepository getRepo() {
        return this.repo;
    }

    public String toString() {
        return "TraceConfig(repo=" + this.getRepo() + ")";
    }

    public TraceConfig(ApplicationRepository repo) {
        this.repo = repo;
    }
}

