/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.xnet.server.codec;

import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.protocol.request.EvpsCommRequest;
import com.its.common.network.NettyUtils;
import com.its.common.utils.ByteUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class EvpsSendByteBufMessageEncoder
extends MessageToByteEncoder<Object> {
    private static final Logger log = LoggerFactory.getLogger(EvpsSendByteBufMessageEncoder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf outByteBuf) throws Exception {
        EvpsCenter center = ApplicationRepository.getCenterObject((Channel)ctx.channel());
        if (center == null) {
            log.error("SEND: [{}]. Not Found Channel Center Object... Oops Will be closed.", (Object)NettyUtils.getAddress((Channel)ctx.channel()));
            ApplicationRepository.closeChannel(null, (Channel)ctx.channel());
            return;
        }
        try {
            MDC.put((String)"id", (String)center.getLogKey());
            if (!(msg instanceof EvpsCommRequest)) {
                log.info("SEND: [{}]. Unknown Send Object type {}.", (Object)center.getLogKey(), (Object)msg.getClass().getName());
                ApplicationRepository.closeChannel((EvpsCenter)center, (Channel)ctx.channel());
                return;
            }
            EvpsCommRequest sendData = (EvpsCommRequest)msg;
            if (!sendData.makeCrc()) {
                log.error("SEND: [{}]. Make CRC Failed: {} Bytes, will be closed.", (Object)center.getLogKey(), (Object)sendData.getPacket().length);
                ApplicationRepository.closeChannel((EvpsCenter)center, (Channel)ctx.channel());
            } else {
                outByteBuf.writeBytes(sendData.getPacket());
                center.getNetState().setLastSendTime();
                if (center.isDump()) {
                    log.info("SEND: [{}]. {} Bytes. {}", new Object[]{center.getLogKey(), sendData.getPacket().length, ByteUtils.byteArrayToHex((byte[])sendData.getPacket())});
                } else {
                    log.info("SEND: [{}]. {} Bytes.", (Object)center.getLogKey(), (Object)sendData.getPacket().length);
                }
            }
        }
        catch (Exception e) {
            log.error("SEND: [{}]. Exception Error: will be closed: {}.", (Object)center.getLogKey(), (Object)e.getMessage());
            ApplicationRepository.closeChannel((EvpsCenter)center, (Channel)ctx.channel());
        }
        finally {
            MDC.remove((String)center.getLogKey());
            MDC.clear();
        }
    }
}

