/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.xnet.server.process.response;

import com.evps.comm.server.kafka.KafkaProducerService;
import com.evps.comm.server.process.dbms.DbmsData;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.kafka.dto.KafkaEvpsEventDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.protocol.response.EvpsCommResponse;
import com.evps.common.protocol.response.RecvPacketDto;
import com.evps.common.utils.EvpsByteUtils;
import com.evps.common.utils.EvpsUtils;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvpsEvent
implements EvpsCommResponse {
    private static final Logger log = LoggerFactory.getLogger(EvpsEvent.class);
    private final DbmsDataProcess dbmsDataProcess;
    private final KafkaProducerService kafkaProducerService;

    public boolean response(RecvPacketDto packet) {
        boolean result = true;
        try {
            log.info("[{}]. EvpsEvent.response. Service Id: {}.", (Object)packet.getCenter().getLogKey(), (Object)packet.getPacket().getServiceId());
            return this.makeData(packet, packet.getPacket().getBuffer());
        }
        catch (Exception e) {
            log.error("[{}]. EvpsEvent.response: Service Id: {}, Exception. will be closed. {}", new Object[]{packet.getCenter().getLogKey(), packet.getPacket().getServiceId(), e.getMessage()});
            result = false;
            return result;
        }
    }

    private KafkaEvpsEventDto getData(String serviceId, byte[] buffer, int idx, String clctDt) {
        byte[] vehNoArr = Arrays.copyOfRange(buffer, idx, idx + 10);
        idx += 10;
        int currentLat = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        int currentLng = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        int speed = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        int distance = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        return KafkaEvpsEventDto.builder().clctDt(clctDt).serviceId(serviceId).evNo(EvpsByteUtils.toString((byte[])vehNoArr)).eventCd(Integer.valueOf(1)).curLat(Double.valueOf((double)currentLat / 1000000.0)).curLng(Double.valueOf((double)currentLng / 1000000.0)).curSpd(Integer.valueOf(speed)).remDist(Integer.valueOf(distance)).build();
    }

    private boolean makeData(RecvPacketDto packet, byte[] buffer) {
        EvpsCenter center = packet.getCenter();
        if (buffer == null || buffer.length != 26) {
            log.error("[{}]. EvpsEvent.response: Service Id: {}, Data Length Error: Required data length({}), Cur({}). will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), 26, buffer == null ? 0 : buffer.length});
            return false;
        }
        String clctDt = EvpsUtils.getClctDt();
        KafkaEvpsEventDto eventDto = this.getData(packet.getPacket().getServiceId(), buffer, 0, clctDt);
        if (center.isDump()) {
            log.info("[{}]. EvpsEvent.response: Service Id: {}, {}", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), eventDto});
        }
        this.kafkaProducerService.sendEvpsEventTopic(eventDto);
        this.dbmsDataProcess.add(new DbmsData(12, center, (Object)eventDto));
        KafkaEvpsServiceDto service = ApplicationRepository.getService((String)eventDto.getServiceId());
        if (service == null) {
            log.error("[{}]. EvpsEvent.response: Service Id: {}, Not Found Service Information.", (Object)center.getLogKey(), (Object)eventDto.getServiceId());
        } else {
            service.setCurLat(eventDto.getCurLat());
            service.setCurLng(eventDto.getCurLng());
            service.setCurSpd(eventDto.getCurSpd());
            service.setServiceDist(eventDto.getRemDist());
            service.updateLastCommTime();
        }
        return true;
    }

    public EvpsEvent(DbmsDataProcess dbmsDataProcess, KafkaProducerService kafkaProducerService) {
        this.dbmsDataProcess = dbmsDataProcess;
        this.kafkaProducerService = kafkaProducerService;
    }
}

