/*
 * Decompiled with CFR 0.152.
 */
package com.evps.simulator.kafka.producer.config;

import com.its.common.utils.NetUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="application.kafka")
public class KafkaConfig {
    private static final Logger log = LoggerFactory.getLogger(KafkaConfig.class);
    private String bootstrapServers;
    private String groupId = "evps-kafka-producer";
    private String pingTopic = "ping-topic";
    private String consumerGroupId = "evps-comm-server";
    private String consumerAckConfig = "1";
    private boolean multiConnect = false;
    private boolean enableNode = false;
    private String nodeServers = "";
    public List<Map<String, String>> props = new ArrayList();

    @PostConstruct
    private void init() {
        log.info("{}", (Object)this);
    }

    public String getGroupId() {
        return this.consumerGroupId + "-" + NetUtils.getHostName();
    }

    public Map<String, Object> getConsumerPropertiesMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bootstrap.servers", this.bootstrapServers);
        properties.put("group.id", this.getGroupId());
        properties.put("enable.auto.commit", "true");
        properties.put("auto.commit.interval.ms", 1);
        properties.put("session.timeout.ms", "10000");
        properties.put("auto.offset.reset", "latest");
        properties.put("max.poll.interval.ms", "100");
        properties.put("check.crcs", false);
        properties.put("max.poll.records", 1);
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", LongDeserializer.class);
        return properties;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getPingTopic() {
        return this.pingTopic;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public String getConsumerAckConfig() {
        return this.consumerAckConfig;
    }

    public boolean isMultiConnect() {
        return this.multiConnect;
    }

    public boolean isEnableNode() {
        return this.enableNode;
    }

    public String getNodeServers() {
        return this.nodeServers;
    }

    public List<Map<String, String>> getProps() {
        return this.props;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setPingTopic(String pingTopic) {
        this.pingTopic = pingTopic;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public void setConsumerAckConfig(String consumerAckConfig) {
        this.consumerAckConfig = consumerAckConfig;
    }

    public void setMultiConnect(boolean multiConnect) {
        this.multiConnect = multiConnect;
    }

    public void setEnableNode(boolean enableNode) {
        this.enableNode = enableNode;
    }

    public void setNodeServers(String nodeServers) {
        this.nodeServers = nodeServers;
    }

    public void setProps(List<Map<String, String>> props) {
        this.props = props;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConfig)) {
            return false;
        }
        KafkaConfig other = (KafkaConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isMultiConnect() != other.isMultiConnect()) {
            return false;
        }
        if (this.isEnableNode() != other.isEnableNode()) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$pingTopic = this.getPingTopic();
        String other$pingTopic = other.getPingTopic();
        if (this$pingTopic == null ? other$pingTopic != null : !this$pingTopic.equals(other$pingTopic)) {
            return false;
        }
        String this$consumerGroupId = this.getConsumerGroupId();
        String other$consumerGroupId = other.getConsumerGroupId();
        if (this$consumerGroupId == null ? other$consumerGroupId != null : !this$consumerGroupId.equals(other$consumerGroupId)) {
            return false;
        }
        String this$consumerAckConfig = this.getConsumerAckConfig();
        String other$consumerAckConfig = other.getConsumerAckConfig();
        if (this$consumerAckConfig == null ? other$consumerAckConfig != null : !this$consumerAckConfig.equals(other$consumerAckConfig)) {
            return false;
        }
        String this$nodeServers = this.getNodeServers();
        String other$nodeServers = other.getNodeServers();
        if (this$nodeServers == null ? other$nodeServers != null : !this$nodeServers.equals(other$nodeServers)) {
            return false;
        }
        List this$props = this.getProps();
        List other$props = other.getProps();
        return !(this$props == null ? other$props != null : !((Object)this$props).equals(other$props));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMultiConnect() ? 79 : 97);
        result = result * 59 + (this.isEnableNode() ? 79 : 97);
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $pingTopic = this.getPingTopic();
        result = result * 59 + ($pingTopic == null ? 43 : $pingTopic.hashCode());
        String $consumerGroupId = this.getConsumerGroupId();
        result = result * 59 + ($consumerGroupId == null ? 43 : $consumerGroupId.hashCode());
        String $consumerAckConfig = this.getConsumerAckConfig();
        result = result * 59 + ($consumerAckConfig == null ? 43 : $consumerAckConfig.hashCode());
        String $nodeServers = this.getNodeServers();
        result = result * 59 + ($nodeServers == null ? 43 : $nodeServers.hashCode());
        List $props = this.getProps();
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaConfig(bootstrapServers=" + this.getBootstrapServers() + ", groupId=" + this.getGroupId() + ", pingTopic=" + this.getPingTopic() + ", consumerGroupId=" + this.getConsumerGroupId() + ", consumerAckConfig=" + this.getConsumerAckConfig() + ", multiConnect=" + this.isMultiConnect() + ", enableNode=" + this.isEnableNode() + ", nodeServers=" + this.getNodeServers() + ", props=" + this.getProps() + ")";
    }
}

