/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.repository;

import com.evps.comm.local.config.ApplicationConfig;
import com.evps.comm.local.dto.CenterDto;
import com.evps.comm.local.dto.PacketSequence;
import com.evps.common.dto.NetState;
import com.its.common.network.NettyUtils;
import com.its.common.spring.SpringUtils;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ApplicationRepository {
    private static final Logger log = LoggerFactory.getLogger(ApplicationRepository.class);
    public static final AttributeKey<CenterDto> CENTER_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"centerInfo");
    public static final CenterDto center = new CenterDto();

    public static void closeChannel(CenterDto center, Channel channel) {
        try {
            if (channel != null) {
                channel.flush();
                channel.disconnect();
                channel.close();
            }
        }
        catch (Exception e) {
            log.error("ApplicationRepository.closeChannel Exception: {}", (Object)e.getMessage());
        }
    }

    public static void setCenterObject(Channel channel, CenterDto center) {
        channel.attr(CENTER_ATTRIBUTE_KEY).set((Object)center);
    }

    public static CenterDto getCenterObject(Channel channel) {
        CenterDto center = (CenterDto)channel.attr(CENTER_ATTRIBUTE_KEY).get();
        if (center == null) {
            log.warn("ApplicationRepository.getCenterObject: {}, Not Found Channel Object. Will be closed.", (Object)NettyUtils.getAddress((Channel)channel));
            ApplicationRepository.closeChannel(null, (Channel)channel);
            return null;
        }
        return center;
    }

    @PostConstruct
    private void init() {
        log.info("AppRepositoryService.init: Start.");
        log.info("AppRepositoryService.init: ..End.");
    }

    public void loadDb() {
        this.loadCenterInfo();
    }

    private void loadCenterInfo() {
        ApplicationConfig config = (ApplicationConfig)SpringUtils.getBean(ApplicationConfig.class);
        try {
            CenterDto dto = CenterDto.builder().idx(0).centerId("L00").centerInfo("\ub3c4\uc2dc\uad50\ud1b5\uc815\ubcf4\uc13c\ud130").ipAddress(config.getServerIp()).commPort(config.getServerPort()).datexUser("EVPS").datexPasswd("EVPS").heartBeat(0).resTime(0).datagramSize(8192).commLogging(false).lastCommTm(0L).seq(new PacketSequence()).netState(new NetState()).build();
            center.setCenter(dto);
        }
        catch (Exception e) {
            log.error("ApplicationRepository.loadCenterInfo: {}.", (Object)e.toString());
        }
    }

    @PreDestroy
    public void destroyService() {
        log.error("ApplicationRepository.destroyService. system terminated.......");
    }
}

