/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.xnet.client.handler;

import com.evps.comm.local.dto.CenterDto;
import com.evps.comm.local.repository.ApplicationRepository;
import com.its.common.network.NettyUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class EvpsLocalClientPacketInboundHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(EvpsLocalClientPacketInboundHandler.class);

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        log.info("{} | Received Data.", (Object)NettyUtils.getRemoteAddress((Channel)ctx.channel()));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        CenterDto center = ApplicationRepository.getCenterObject((Channel)ctx.channel());
        if (center == null) {
            log.error("{}.userEventTriggered: Unknown Center: {}.", (Object)this.getClass().getSimpleName(), (Object)NettyUtils.getAddress((Channel)ctx.channel()));
            return;
        }
        log.info("{}.++channelInactive: {}. {}.", new Object[]{this.getClass().getSimpleName(), center.getCenterId(), center.getIpAddress()});
        center.getNetState().disConnect();
        ApplicationRepository.setCenterObject((Channel)ctx.channel(), null);
        ctx.fireChannelInactive();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object e) throws Exception {
        CenterDto center = ApplicationRepository.getCenterObject((Channel)ctx.channel());
        if (center == null) {
            log.error("{}.userEventTriggered: Unknown Center: {}.", (Object)this.getClass().getSimpleName(), (Object)NettyUtils.getAddress((Channel)ctx.channel()));
            return;
        }
        if (e instanceof IdleStateEvent) {
            IdleStateEvent evt = (IdleStateEvent)e;
        }
        ctx.fireUserEventTriggered(e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        CenterDto center = ApplicationRepository.getCenterObject((Channel)ctx.channel());
        if (center != null) {
            log.error("{}.exceptionCaught: {}.", (Object)this.getClass().getSimpleName(), (Object)center.getCenterId());
        } else {
            log.error("{}.++exceptionCaught: {}.", (Object)this.getClass().getSimpleName(), (Object)NettyUtils.getAddress((Channel)ctx.channel()));
        }
        ctx.fireExceptionCaught(cause);
        ctx.channel().close();
    }
}

