/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.dao.mapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchDaoService {
    private static final Logger log = LoggerFactory.getLogger(BatchDaoService.class);
    protected final int maxBatchSize = 1000;
    protected final SqlSessionFactory sqlSessionFactory;
    protected String serviceName;
    protected int count;

    public BatchDaoService(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String mapperName) {
        int total = 0;
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionFactory.openSession(ExecutorType.SIMPLE, false);
            total = sqlSession.update(mapperName);
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.close();
            }
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertBatch(String mapperName, List<HashMap<String, Object>> lists) {
        int total = lists.size();
        if (total == 0) {
            log.info("[BATCH--DAO] {}:insertBatch: {}: No Data.", (Object)this.serviceName, (Object)mapperName);
            return 0;
        }
        int jobCnt = 0;
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            for (Map map : lists) {
                sqlSession.insert(mapperName, (Object)map);
                this.getClass();
                if (++jobCnt % 1000 != 0 && jobCnt != total) continue;
                sqlSession.flushStatements();
                sqlSession.clearCache();
            }
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.close();
            }
        }
        this.count = total;
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateBatch(String mapperName, List<HashMap<String, Object>> lists) {
        int total = lists.size();
        if (total == 0) {
            log.info("[BATCH--DAO] {}:updateBatch: {}: No Data.", (Object)this.serviceName, (Object)mapperName);
            return 0;
        }
        int jobCnt = 0;
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            for (Map map : lists) {
                sqlSession.update(mapperName, (Object)map);
                this.getClass();
                if (++jobCnt % 1000 != 0 && jobCnt != total) continue;
                sqlSession.flushStatements();
                sqlSession.clearCache();
            }
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.close();
            }
        }
        this.count = total;
        return this.count;
    }

    public int getMaxBatchSize() {
        this.getClass();
        return 1000;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public int getCount() {
        return this.count;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BatchDaoService)) {
            return false;
        }
        BatchDaoService other = (BatchDaoService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMaxBatchSize() != other.getMaxBatchSize()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        SqlSessionFactory this$sqlSessionFactory = this.getSqlSessionFactory();
        SqlSessionFactory other$sqlSessionFactory = other.getSqlSessionFactory();
        if (this$sqlSessionFactory == null ? other$sqlSessionFactory != null : !this$sqlSessionFactory.equals(other$sqlSessionFactory)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        return !(this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BatchDaoService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxBatchSize();
        result = result * 59 + this.getCount();
        SqlSessionFactory $sqlSessionFactory = this.getSqlSessionFactory();
        result = result * 59 + ($sqlSessionFactory == null ? 43 : $sqlSessionFactory.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        return result;
    }

    public String toString() {
        return "BatchDaoService(maxBatchSize=" + this.getMaxBatchSize() + ", sqlSessionFactory=" + this.getSqlSessionFactory() + ", serviceName=" + this.getServiceName() + ", count=" + this.getCount() + ")";
    }
}

