/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.aspect;

import com.evps.comm.server.process.dbms.DbmsData;
import com.its.common.utils.Elapsed;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(LoggingAspect.class);

    @Around(value="@annotation(com.its.common.annotation.ScheduleElapsed)")
    public Object scheduleElapsedTime(ProceedingJoinPoint joinPoint) throws Throwable {
        String scheduleElapsedName = String.format("%45s", joinPoint.getTarget().getClass().getSimpleName() + "." + joinPoint.getSignature().getName());
        Elapsed elapsed = new Elapsed();
        Object proceed = joinPoint.proceed();
        log.info("{}: {}", (Object)scheduleElapsedName, (Object)Elapsed.elapsedTimeStr((long)elapsed.nanoSeconds()));
        return proceed;
    }

    @Around(value="@annotation(com.its.common.annotation.ProcessElapsed)")
    public Object processElapsedTime(ProceedingJoinPoint joinPoint) throws Throwable {
        String processElapsedName = String.format("%45s", joinPoint.getTarget().getClass().getSimpleName() + "." + joinPoint.getSignature().getName());
        Elapsed elapsed = new Elapsed();
        Object proceed = joinPoint.proceed();
        log.info("{}: {}", (Object)processElapsedName, (Object)Elapsed.elapsedTimeStr((long)elapsed.nanoSeconds()));
        return proceed;
    }

    @Around(value="@annotation(com.its.common.annotation.DbmsElapsed)")
    public Object dbmsElapsedTime(ProceedingJoinPoint joinPoint) throws Throwable {
        Object[] params = joinPoint.getArgs();
        DbmsData dbmsData = null;
        if (params.length > 0 && params[0] instanceof DbmsData) {
            dbmsData = (DbmsData)params[0];
        }
        String dbmsElapsedName = String.format("%45s", joinPoint.getTarget().getClass().getSimpleName() + "." + joinPoint.getSignature().getName());
        Elapsed elapsed = new Elapsed();
        Object proceed = joinPoint.proceed();
        if (dbmsData == null) {
            log.info("{}: {}", (Object)dbmsElapsedName, (Object)Elapsed.elapsedTimeStr((long)elapsed.nanoSeconds()));
        }
        return proceed;
    }
}

