/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.service;

import com.evps.comm.server.config.ApplicationConfig;
import com.evps.comm.server.process.dbms.DbmsData;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.its.common.utils.TimeUtils;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EvpsServiceManagerService {
    private static final Logger log = LoggerFactory.getLogger(EvpsServiceManagerService.class);
    private final ApplicationConfig config;
    private final DbmsDataProcess dbmsDataProcess;

    public void checkServiceTimeout() {
        if (this.config.getAutoEndMinutes() == 0) {
            return;
        }
        ArrayList timeoutServiceList = new ArrayList();
        long timeoutMilliSeconds = this.config.getLastCommTimeoutSeconds();
        long autoTimeoutSeconds = (long)this.config.getAutoEndMinutes() * 60L;
        long currentTimeSeconds = System.currentTimeMillis() / 1000L;
        ConcurrentHashMap serviceMap = ApplicationRepository.getServiceMap();
        serviceMap.forEach((key, service) -> {
            long serviceStartTime;
            String serviceId = service.getServiceId();
            EvpsCenter center = (EvpsCenter)service.getCenterObj();
            long lastCommTime = service.getLastCommTime() / 1000L;
            if (currentTimeSeconds - lastCommTime >= timeoutMilliSeconds && currentTimeSeconds - (serviceStartTime = TimeUtils.getStringTimeToSeconds((String)service.getClctDt(), (String)"yyyy-MM-dd HH:mm:ss.SSS", (long)currentTimeSeconds)) >= autoTimeoutSeconds) {
                log.warn("[{}]. checkServiceTimeout: Service Id: {}, ClctDt: {}, Service Timeout: {} seconds.", new Object[]{center.getLogKey(), serviceId, service.getClctDt(), currentTimeSeconds - serviceStartTime});
                timeoutServiceList.add(serviceId);
            }
        });
        for (String serviceId : timeoutServiceList) {
            KafkaEvpsServiceDto service2 = ApplicationRepository.getService((String)serviceId);
            if (service2 == null) {
                log.warn("checkServiceTimeout: Service Id: {}, Timeout Service not found information.", (Object)serviceId);
                continue;
            }
            EvpsCenter center = (EvpsCenter)service2.getCenterObj();
            log.warn("[{}]. checkServiceTimeout: Service Id: {}, Service Auto Timeout: ClctDt: {}.", new Object[]{center.getLogKey(), serviceId, service2.getClctDt()});
            service2.setStatusCd(Integer.valueOf(16));
            ApplicationRepository.delService((String)service2.getServiceId());
            this.dbmsDataProcess.add(new DbmsData(11, center, (Object)service2));
        }
    }

    public EvpsServiceManagerService(ApplicationConfig config, DbmsDataProcess dbmsDataProcess) {
        this.config = config;
        this.dbmsDataProcess = dbmsDataProcess;
    }
}

