/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.xnet.client.process.request;

import com.its.common.utils.ByteUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDateTime;

public class EvpsFrameHead {
    public static final int HEAD_SIZE = 13;
    private final byte stx1 = (byte)85;
    private final byte stx2 = (byte)69;
    private final byte opCode;
    private int sequence;
    private int current;
    private int total;
    private final short year;
    private final byte month;
    private final byte day;
    private final byte hour;
    private final byte minute;
    private final byte second;
    private final String serviceId;
    private int length;

    public EvpsFrameHead(byte opCode, String serviceId) {
        this.opCode = opCode;
        this.sequence = 1;
        this.current = 1;
        this.total = 1;
        LocalDateTime now = LocalDateTime.now();
        this.year = (short)now.getYear();
        this.month = (byte)now.getMonthValue();
        this.day = (byte)now.getDayOfMonth();
        this.hour = (byte)now.getHour();
        this.minute = (byte)now.getMinute();
        this.second = (byte)now.getSecond();
        this.serviceId = serviceId;
        this.length = 1;
    }

    public int getSize() {
        return 37;
    }

    public ByteBuffer getBuffer() {
        ByteBuffer head = ByteBuffer.allocate(37);
        head.order(ByteOrder.BIG_ENDIAN);
        head.put(this.stx1);
        head.put(this.stx2);
        head.put(this.opCode);
        head.putShort((short)(this.sequence & 0xFFFF));
        head.putShort((short)(this.current & 0xFFFF));
        head.putShort((short)(this.total & 0xFFFF));
        head.putShort((short)(this.year & 0xFFFF));
        head.put(this.month);
        head.put(this.day);
        head.put(this.hour);
        head.put(this.minute);
        head.put(this.second);
        byte[] serviceIdArr = new byte[19];
        ByteUtils.copyStringToByteArray((byte[])serviceIdArr, (String)this.serviceId);
        head.put(serviceIdArr);
        head.putShort((short)(this.length & 0xFFFF));
        return head;
    }

    public byte getStx1() {
        return this.stx1;
    }

    public byte getStx2() {
        return this.stx2;
    }

    public byte getOpCode() {
        return this.opCode;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getCurrent() {
        return this.current;
    }

    public int getTotal() {
        return this.total;
    }

    public short getYear() {
        return this.year;
    }

    public byte getMonth() {
        return this.month;
    }

    public byte getDay() {
        return this.day;
    }

    public byte getHour() {
        return this.hour;
    }

    public byte getMinute() {
        return this.minute;
    }

    public byte getSecond() {
        return this.second;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public int getLength() {
        return this.length;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvpsFrameHead)) {
            return false;
        }
        EvpsFrameHead other = (EvpsFrameHead)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getStx1() != other.getStx1()) {
            return false;
        }
        if (this.getStx2() != other.getStx2()) {
            return false;
        }
        if (this.getOpCode() != other.getOpCode()) {
            return false;
        }
        if (this.getSequence() != other.getSequence()) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getYear() != other.getYear()) {
            return false;
        }
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        if (this.getDay() != other.getDay()) {
            return false;
        }
        if (this.getHour() != other.getHour()) {
            return false;
        }
        if (this.getMinute() != other.getMinute()) {
            return false;
        }
        if (this.getSecond() != other.getSecond()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        return !(this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EvpsFrameHead;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStx1();
        result = result * 59 + this.getStx2();
        result = result * 59 + this.getOpCode();
        result = result * 59 + this.getSequence();
        result = result * 59 + this.getCurrent();
        result = result * 59 + this.getTotal();
        result = result * 59 + this.getYear();
        result = result * 59 + this.getMonth();
        result = result * 59 + this.getDay();
        result = result * 59 + this.getHour();
        result = result * 59 + this.getMinute();
        result = result * 59 + this.getSecond();
        result = result * 59 + this.getLength();
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        return result;
    }

    public String toString() {
        return "EvpsFrameHead(stx1=" + this.getStx1() + ", stx2=" + this.getStx2() + ", opCode=" + this.getOpCode() + ", sequence=" + this.getSequence() + ", current=" + this.getCurrent() + ", total=" + this.getTotal() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", hour=" + this.getHour() + ", minute=" + this.getMinute() + ", second=" + this.getSecond() + ", serviceId=" + this.getServiceId() + ", length=" + this.getLength() + ")";
    }
}

