/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.process.dbms;

import com.evps.comm.server.config.ThreadPoolInitializer;
import com.evps.comm.server.dao.mapper.EvpsCenterMapper;
import com.evps.comm.server.dao.mapper.EvpsServiceMapper;
import com.evps.comm.server.dao.mapper.ProcessMapper;
import com.evps.comm.server.dao.mapper.batch.EvpCommServerDao;
import com.evps.comm.server.entity.TbRegionCenterComm;
import com.evps.comm.server.process.dbms.DbmsData;
import com.evps.comm.server.process.dbms.DbmsDataAsyncTask;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.kafka.dto.KafkaEvpsEventDto;
import com.evps.common.kafka.dto.KafkaEvpsNodeDto;
import com.evps.common.kafka.dto.KafkaEvpsPhaseDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.kafka.dto.KafkaEvpsSignalDto;
import com.evps.common.protocol.eEvpsOpCode;
import com.its.common.spring.SpringUtils;
import com.its.common.utils.Elapsed;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class DbmsDataProcess {
    private static final Logger log = LoggerFactory.getLogger(DbmsDataProcess.class);
    private final LinkedBlockingQueue<DbmsData> dbmsDataBlockingQueue = new LinkedBlockingQueue(1000);
    private final ThreadPoolExecutor taskExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    private final DbmsDataAsyncTask asyncTask;
    private final ProcessMapper processMapper;
    private final EvpsServiceMapper serviceMapper;
    private final EvpCommServerDao evpCommServerDao;
    private final EvpsCenterMapper evpsCenterMapper;

    public void run() {
        log.info("DbmsDataProcess.run: Start.");
        ThreadPoolInitializer poolInitializer = (ThreadPoolInitializer)SpringUtils.getBean(ThreadPoolInitializer.class);
        int executePool = poolInitializer.getDbms();
        for (int ii = 0; ii < executePool; ++ii) {
            log.info("DbmsDataProcess.Task: {}", (Object)ii);
            this.taskExecutor.execute(() -> {
                boolean isRunning = true;
                while (isRunning) {
                    try {
                        DbmsData data = (DbmsData)this.dbmsDataBlockingQueue.take();
                        this.asyncTask.run(this, data);
                    }
                    catch (Exception e) {
                        log.error("DbmsDataProcess.Task: Exception: {}", (Object)e.getMessage(), (Object)e);
                        Thread.currentThread().interrupt();
                        isRunning = false;
                    }
                }
            });
        }
        log.info("DbmsDataProcess.run: ..End.");
    }

    public void runJob(DbmsData data) {
        if (data.getType() == 0) {
            String processId = (String)data.getData();
            this.processMapper.updateProcessState(processId);
        } else {
            this.process(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DbmsData data) {
        int result = -1;
        int type = -1;
        String typeDesc = "";
        EvpsCenter center = data.getCenter();
        try {
            MDC.put((String)"id", (String)center.getLogKey());
            Elapsed elapsed1 = new Elapsed();
            type = data.getType();
            block11 : switch (type) {
                case 10: {
                    typeDesc = "DBMS_DATA_INS_SERVICE";
                    KafkaEvpsServiceDto newService = (KafkaEvpsServiceDto)data.getData();
                    try {
                        result = this.serviceMapper.insertEvpService(newService);
                    }
                    catch (Exception e) {
                        log.error("[{}]. DBMS_DATA_INS_SERVICE: {}", (Object)center.getLogKey(), (Object)newService);
                        log.error("[{}]. DBMS_DATA_INS_SERVICE: Exception: {}\r\n", (Object)center.getLogKey(), (Object)e.toString());
                    }
                    break;
                }
                case 11: {
                    typeDesc = "DBMS_DATA_UPD_SERVICE";
                    KafkaEvpsServiceDto updService = (KafkaEvpsServiceDto)data.getData();
                    try {
                        result = this.serviceMapper.updateEvpService(updService);
                    }
                    catch (Exception e) {
                        log.error("[{}]. DBMS_DATA_UPD_SERVICE: {}", (Object)center.getLogKey(), (Object)updService);
                        log.error("[{}]. DBMS_DATA_UPD_SERVICE: Exception: {}\r\n", (Object)center.getLogKey(), (Object)e.toString());
                    }
                    break;
                }
                case 12: {
                    KafkaEvpsServiceDto service;
                    typeDesc = "DBMS_DATA_INS_EVENT";
                    boolean insData = true;
                    KafkaEvpsEventDto event = (KafkaEvpsEventDto)data.getData();
                    if (event.getEventCd() < 2 && (service = ApplicationRepository.getService((String)event.getServiceId())) == null) {
                        insData = false;
                        result = 0;
                        log.warn("[{}]. DBMS_DATA_INS_EVENT: EVPS service has already ended. {}", (Object)center.getLogKey(), (Object)event);
                    }
                    if (insData) {
                        try {
                            result = this.serviceMapper.insertEvpEventCurr(event);
                        }
                        catch (Exception e) {
                            log.error("[{}]. DBMS_DATA_INS_EVENT_CURR: {}", (Object)center.getLogKey(), (Object)event);
                            log.error("[{}]. DBMS_DATA_INS_EVENT_CURR: Exception: {}\r\n", (Object)center.getLogKey(), (Object)e.toString());
                        }
                    }
                    try {
                        result = this.serviceMapper.insertEvpEvent(event);
                    }
                    catch (Exception e) {
                        log.error("[{}]. DBMS_DATA_INS_EVENT: {}", (Object)center.getLogKey(), (Object)event);
                        log.error("[{}]. DBMS_DATA_INS_EVENT: Exception: {}\r\n", (Object)center.getLogKey(), (Object)e.toString());
                    }
                    break;
                }
                case 13: {
                    typeDesc = "DBMS_DATA_INS_ROUTE";
                    KafkaEvpsServiceDto service = (KafkaEvpsServiceDto)data.getData();
                    try {
                        result = this.evpCommServerDao.insertEvpRouteBatch(service);
                    }
                    catch (Exception e) {
                        log.error("[{}]. DBMS_DATA_INS_ROUTE: {}", (Object)center.getLogKey(), (Object)service);
                        log.error("[{}]. DBMS_DATA_INS_ROUTE: Exception: {}\r\n", (Object)center.getLogKey(), (Object)e.toString());
                    }
                    break;
                }
                case 14: {
                    typeDesc = "DBMS_DATA_INS_NODE";
                    KafkaEvpsNodeDto nodeDto = (KafkaEvpsNodeDto)data.getData();
                    try {
                        result = this.evpCommServerDao.insertEvpNodeBatch(nodeDto);
                    }
                    catch (Exception e) {
                        log.error("[{}]. DBMS_DATA_INS_NODE: {}", (Object)center.getLogKey(), (Object)nodeDto);
                        log.error("[{}]. DBMS_DATA_INS_NODE: Exception: {}\r\n", (Object)center.getLogKey(), (Object)e.toString());
                    }
                    break;
                }
                case 15: {
                    typeDesc = "DBMS_DATA_INS_PHASE";
                    KafkaEvpsPhaseDto phaseDto = (KafkaEvpsPhaseDto)data.getData();
                    try {
                        result = this.evpCommServerDao.insertEvpPhaseBatch(phaseDto);
                    }
                    catch (Exception e) {
                        log.error("[{}]. DBMS_DATA_INS_PHASE: {}", (Object)center.getLogKey(), (Object)phaseDto);
                        log.error("[{}]. DBMS_DATA_INS_PHASE: Exception: {}\r\n", (Object)center.getLogKey(), (Object)e.toString());
                    }
                    break;
                }
                case 16: {
                    typeDesc = "DBMS_DATA_INS_SIGNAL";
                    KafkaEvpsSignalDto signalDto = (KafkaEvpsSignalDto)data.getData();
                    try {
                        result = this.evpCommServerDao.insertEvpSignalCurrBatch(signalDto);
                    }
                    catch (Exception e) {
                        log.error("[{}]. insertEvpSignalCurr: {}", (Object)center.getLogKey(), (Object)signalDto);
                        log.error("[{}]. insertEvpSignalCurr: Exception: {}\r\n", (Object)center.getLogKey(), (Object)e.toString());
                    }
                    try {
                        result = this.evpCommServerDao.insertEvpSignalBatch(signalDto);
                    }
                    catch (Exception e) {
                        log.error("[{}]. insertEvpSignal: {}", (Object)center.getLogKey(), (Object)signalDto);
                        log.error("[{}]. insertEvpSignal: Exception: {}\r\n", (Object)center.getLogKey(), (Object)e.toString());
                    }
                    break;
                }
                case 1: {
                    typeDesc = "DBMS_DATA_CENTER_STTS";
                    TbRegionCenterComm stts = (TbRegionCenterComm)data.getData();
                    try {
                        switch (stts.getCommState()) {
                            case 0: {
                                typeDesc = "CENTER_COMM_START";
                                result = this.evpsCenterMapper.updateCommStateConnect(stts.getCenterId());
                                result = this.evpsCenterMapper.insertEvpCommHs(stts.getCenterId(), "1", "");
                                break;
                            }
                            case 1: {
                                typeDesc = "CENTER_COMM_STOP";
                                result = this.evpsCenterMapper.updateCommStateDisconnect(stts.getCenterId());
                                result = this.evpsCenterMapper.insertEvpCommHs(stts.getCenterId(), "0", "");
                                break;
                            }
                            case 2: {
                                typeDesc = "CENTER_COMM_LAST";
                                result = this.evpsCenterMapper.updateCommLastComm(stts.getCenterId());
                                if (stts.getOpCode() == eEvpsOpCode.EVPS_NET_PING.getValue()) break block11;
                                result = this.evpsCenterMapper.insertEvpCommHs(stts.getCenterId(), "0", stts.getOpCodeDesc());
                                break;
                            }
                            default: {
                                typeDesc = "UNKNOWN DBMS_DATA_CENTER_STTS";
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("[{}]. DBMS_DATA_CENTER_STTS: {}, {}", new Object[]{center.getLogKey(), typeDesc, stts});
                        log.error("[{}]. DBMS_DATA_CENTER_STTS: Exception: {}\r\n", (Object)center.getLogKey(), (Object)e.toString());
                    }
                    break;
                }
                default: {
                    log.error("[{}]. DbmsJobProcess.process: Unknown Request {}.\r\n", (Object)center.getLogKey(), (Object)type);
                }
            }
            log.info("[{}]. DbmsDataProcess.run: Job: {}, {} EA. {}", new Object[]{center.getLogKey(), typeDesc, result, Elapsed.elapsedTimeStr((long)elapsed1.nanoSeconds())});
        }
        finally {
            MDC.remove((String)center.getLogKey());
            MDC.clear();
        }
    }

    public boolean add(DbmsData data) {
        boolean offer = false;
        try {
            offer = this.dbmsDataBlockingQueue.offer(data);
            if (!offer) {
                log.error("DbmsDataProcess.add: Queue Full Error, Size: {} EA", (Object)this.dbmsDataBlockingQueue.size());
            }
        }
        catch (Exception e) {
            log.error("DbmsDataProcess.add: Exception: {}", (Object)e.getMessage(), (Object)e);
        }
        return offer;
    }

    public DbmsDataProcess(DbmsDataAsyncTask asyncTask, ProcessMapper processMapper, EvpsServiceMapper serviceMapper, EvpCommServerDao evpCommServerDao, EvpsCenterMapper evpsCenterMapper) {
        this.asyncTask = asyncTask;
        this.processMapper = processMapper;
        this.serviceMapper = serviceMapper;
        this.evpCommServerDao = evpCommServerDao;
        this.evpsCenterMapper = evpsCenterMapper;
    }
}

