/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.xnet.server.process.response;

import com.evps.comm.server.kafka.KafkaProducerService;
import com.evps.comm.server.process.dbms.DbmsData;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.kafka.dto.EvpsRouteInfo;
import com.evps.common.kafka.dto.KafkaEvpsEventDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.protocol.response.EvpsCommResponse;
import com.evps.common.protocol.response.RecvPacketDto;
import com.evps.common.utils.EvpsByteUtils;
import com.evps.common.utils.EvpsUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvpsService
implements EvpsCommResponse {
    private static final Logger log = LoggerFactory.getLogger(EvpsService.class);
    private final DbmsDataProcess dbmsDataProcess;
    private final KafkaProducerService kafkaProducerService;

    public boolean response(RecvPacketDto packet) {
        boolean result = true;
        try {
            log.info("[{}]. EvpsService.response. Service Id: {}.", (Object)packet.getCenter().getLogKey(), (Object)packet.getPacket().getServiceId());
            if (packet.getPacket().getCurrent() == 1 && packet.getPacket().getTotal() == 1) {
                return this.makeData(packet, packet.getPacket().getBuffer());
            }
            if (packet.getPacket().getCurrent() == 1) {
                packet.getCenter().clearServiceBuffer();
            }
            packet.getCenter().addServiceBuffer(packet.getPacket().getBuffer());
            if (packet.getPacket().getCurrent() == packet.getPacket().getTotal()) {
                log.info("[{}]. EvpsService.response: Service Id: {}, Recv All Frames. Sequence: Curr: ({}), Tot: ({})", new Object[]{packet.getCenter().getLogKey(), packet.getPacket().getServiceId(), packet.getPacket().getCurrent(), packet.getPacket().getTotal()});
                result = this.makeData(packet, packet.getCenter().getServiceBuffer().array());
                packet.getCenter().clearServiceBuffer();
            }
        }
        catch (Exception e) {
            log.error("[{}]. EvpsService.response: Service Id: {}, Exception. will be closed. {}", new Object[]{packet.getCenter().getLogKey(), packet.getPacket().getServiceId(), e.getMessage()});
            result = false;
        }
        return result;
    }

    private boolean makeData(RecvPacketDto packet, byte[] buffer) {
        EvpsCenter center = packet.getCenter();
        if (buffer == null || buffer.length < 180) {
            log.error("[{}]. EvpsService.response: Service Id: {}, Data Length Error: Required minimum data length({}), Cur({}). will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), 180, buffer == null ? 0 : buffer.length});
            return false;
        }
        int idx = 0;
        byte[] vehNoArr = Arrays.copyOfRange(buffer, idx, idx + 10);
        idx += 10;
        int currentLat = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        int currentLng = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        byte[] serviceNameArr = Arrays.copyOfRange(buffer, idx, idx + 100);
        idx += 100;
        int arrivalLat = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        int arrivalLng = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        int vehicleLength = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        byte[] ocrNoArr = Arrays.copyOfRange(buffer, idx, idx + 20);
        byte[] ocrTypeArr = Arrays.copyOfRange(buffer, idx += 20, idx + 20);
        idx += 20;
        int arrivalTime = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        int distance = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        int routeCount = (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        log.info("[{}]. EvpsService.response: Service Id: {}, routeCount({}).", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), routeCount});
        int reqDataSize = 8 * routeCount;
        if (buffer.length - idx != reqDataSize) {
            log.error("[{}]. EvpsService.response: Service Id: {}, Data Length Error: routeCount({}), Required data length({}), Cur({}). will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), routeCount, reqDataSize, buffer.length - idx});
            return false;
        }
        String clctDt = EvpsUtils.getClctDt();
        KafkaEvpsServiceDto service = KafkaEvpsServiceDto.builder().serviceId(packet.getPacket().getServiceId()).clctDt(clctDt).evNo(EvpsByteUtils.toString((byte[])vehNoArr)).curLat(Double.valueOf((double)currentLat / 1000000.0)).curLng(Double.valueOf((double)currentLng / 1000000.0)).serviceNm(EvpsByteUtils.toString((byte[])serviceNameArr).trim()).arrLat(Double.valueOf((double)arrivalLat / 1000000.0)).arrLng(Double.valueOf((double)arrivalLng / 1000000.0)).arrTm(Integer.valueOf(arrivalTime)).vehLen(Integer.valueOf(vehicleLength)).ocrNo(EvpsByteUtils.toString((byte[])ocrNoArr).trim()).ocrType(EvpsByteUtils.toString((byte[])ocrTypeArr).trim()).serviceDist(Integer.valueOf(distance)).curSpd(Integer.valueOf(0)).statusCd(Integer.valueOf(1)).routeList(new ArrayList()).lastCommTime(System.currentTimeMillis()).centerObj((Object)center).build();
        if (center.isDump()) {
            log.info("[{}]. EvpsService.response: Service Id: {}, {}", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), service});
        }
        for (int ii = 0; ii < routeCount; ++ii) {
            int routeLat = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
            int routeLng = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
            EvpsRouteInfo route = EvpsRouteInfo.builder().serviceId(service.getServiceId()).clctDt(clctDt).seqNo(Integer.valueOf(ii + 1)).lat((double)routeLat / 1000000.0).lng((double)routeLng / 1000000.0).build();
            service.getRouteList().add(route);
        }
        log.info("[{}]. EvpsService.response: Service Id: {}, Route List {} EA.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), service.getRouteList().size()});
        if (center.isDump()) {
            log.info("[{}]. EvpsService.response: Service Id: {}, Route: {}.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), service.getRouteList()});
        }
        ApplicationRepository.addService((String)service.getServiceId(), (KafkaEvpsServiceDto)service);
        this.kafkaProducerService.sendEvpsServiceTopic(service);
        this.dbmsDataProcess.add(new DbmsData(10, center, (Object)service));
        if (!service.getRouteList().isEmpty()) {
            this.dbmsDataProcess.add(new DbmsData(13, center, (Object)service));
        }
        KafkaEvpsEventDto event = KafkaEvpsEventDto.builder().clctDt(clctDt).serviceId(service.getServiceId()).evNo(EvpsByteUtils.toString((byte[])vehNoArr).trim()).eventCd(Integer.valueOf(1)).curLat(service.getCurLat()).curLng(service.getCurLng()).curSpd(service.getCurSpd()).remDist(service.getServiceDist()).build();
        this.dbmsDataProcess.add(new DbmsData(12, center, (Object)event));
        return true;
    }

    public EvpsService(DbmsDataProcess dbmsDataProcess, KafkaProducerService kafkaProducerService) {
        this.dbmsDataProcess = dbmsDataProcess;
        this.kafkaProducerService = kafkaProducerService;
    }
}

