/*
 * Decompiled with CFR 0.152.
 */
package com.evps.simulator.kafka.producer.kafka;

import com.evps.common.kafka.dto.KafkaEvpsData;
import com.evps.common.kafka.dto.KafkaEvpsEventDto;
import com.evps.common.kafka.dto.KafkaEvpsNodeDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceEndDto;
import com.evps.common.kafka.dto.KafkaEvpsSignalDto;
import com.evps.simulator.kafka.producer.config.KafkaConfig;
import com.evps.simulator.kafka.producer.kafka.KafkaProducerFactory;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFuture;

@Service
public class KafkaProducerService {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducerService.class);
    private final KafkaConfig config;
    private final String topicName = "utic-evps-sim";
    private KafkaTemplate<String, KafkaEvpsData> uticEvpsProducer;

    @PostConstruct
    void init() {
        this.uticEvpsProducer = KafkaProducerFactory.createJsonTemplate((String)this.config.getBootstrapServers(), (List)this.config.props);
        log.info("[{}] ------------------", (Object)this.getClass().getSimpleName());
        log.info("[{}]   serviceProducer: {}", (Object)this.getClass().getSimpleName(), (Object)this.uticEvpsProducer);
    }

    public void sendEvpsServiceTopic(KafkaEvpsServiceDto data) {
        if (this.uticEvpsProducer != null) {
            try {
                this.getClass();
                ListenableFuture result = this.uticEvpsProducer.send("utic-evps-sim", (Object)"evps-service", (Object)data);
                log.info("sendEvpsServiceTopic: {}, Key: {}, Data: {}", new Object[]{"evps-service", data.getServiceId(), data});
            }
            catch (Exception e) {
                log.error("sendEvpsServiceTopic: {}, {}: {}", new Object[]{"evps-service", data.getServiceId(), e.toString()});
            }
        }
    }

    public void sendEvpsServiceEndTopic(KafkaEvpsServiceEndDto data) {
        if (this.uticEvpsProducer != null) {
            try {
                this.getClass();
                ListenableFuture result = this.uticEvpsProducer.send("utic-evps-sim", (Object)"evps-service-end", (Object)data);
                log.info("sendEvpsServiceEndTopic: {}, Key: {}, Data: {}", new Object[]{"evps-service-end", data.getServiceId(), data});
            }
            catch (Exception e) {
                log.error("sendEvpsServiceEndTopic: {}, {}: {}", new Object[]{"evps-service-end", data.getServiceId(), e.toString()});
            }
        }
    }

    public void sendEvpsNodeTopic(KafkaEvpsNodeDto data) {
        if (this.uticEvpsProducer != null) {
            try {
                this.getClass();
                ListenableFuture result = this.uticEvpsProducer.send("utic-evps-sim", (Object)"evps-node", (Object)data);
                log.info("sendEvpsNodeTopic: {}, Key: {}, Data: {}", new Object[]{"evps-node", data.getServiceId(), data});
            }
            catch (Exception e) {
                log.error("sendEvpsNodeTopic: {}, {}: {}", new Object[]{"evps-node", data.getServiceId(), e.toString()});
            }
        }
    }

    public void sendEvpsSignalTopic(KafkaEvpsSignalDto data) {
        if (this.uticEvpsProducer != null) {
            try {
                this.getClass();
                ListenableFuture result = this.uticEvpsProducer.send("utic-evps-sim", (Object)"evps-signal", (Object)data);
                log.info("sendEvpsSignalTopic: {}, Key: {}, Data: {}", new Object[]{"evps-signal", data.getServiceId(), data});
            }
            catch (Exception e) {
                log.error("sendEvpsSignalTopic: {}, {}: {}", new Object[]{"evps-signal", data.getServiceId(), e.toString()});
            }
        }
    }

    public void sendEvpsEventTopic(KafkaEvpsEventDto data) {
        if (this.uticEvpsProducer != null) {
            try {
                this.getClass();
                ListenableFuture result = this.uticEvpsProducer.send("utic-evps-sim", (Object)"evps-event", (Object)data);
                log.info("sendEvpsEventTopic: {}, Key: {}, Data: {}", new Object[]{"evps-event", data.getServiceId(), data});
            }
            catch (Exception e) {
                log.error("sendEvpsEventTopic: {}, {}: {}", new Object[]{"evps-event", data.getServiceId(), e.toString()});
            }
        }
    }

    public void shutdown() {
        try {
            if (this.uticEvpsProducer != null) {
                this.uticEvpsProducer.destroy();
            }
        }
        catch (Exception e) {
            log.error("Failed to shutdown: {}", (Object)e.getMessage());
        }
    }

    public KafkaProducerService(KafkaConfig config, KafkaTemplate<String, KafkaEvpsData> uticEvpsProducer) {
        this.config = config;
        this.uticEvpsProducer = uticEvpsProducer;
    }
}

