/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.xnet.client;

import com.evps.comm.local.config.ApplicationConfig;
import com.evps.comm.local.dto.CenterDto;
import com.evps.comm.local.repository.ApplicationRepository;
import com.evps.comm.local.xnet.client.EvpsLocalClient;
import com.evps.comm.local.xnet.client.EvpsLocalClientBootstrapFactory;
import com.evps.comm.local.xnet.client.codec.EvpsLocalClientEncoder;
import com.evps.comm.local.xnet.client.handler.EvpsLocalClientPacketInboundHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EvpsLocalClientCommService {
    private static final Logger log = LoggerFactory.getLogger(EvpsLocalClientCommService.class);
    private final ApplicationConfig config;
    private final ApplicationRepository repo;
    private final EvpsLocalClientPacketInboundHandler evpsLocalClientPacketInboundHandler;
    private final EvpsLocalClientEncoder evpsLocalClientEncoder;
    private final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private final List<EvpsLocalClient> clientTasks = Collections.synchronizedList(new ArrayList());
    private EvpsLocalClientBootstrapFactory bootstrapFactory;

    @PostConstruct
    void init() {
        this.bootstrapFactory = new EvpsLocalClientBootstrapFactory(1, this.config.getConnectionTimeout());
    }

    public void run() {
        log.info("EvpsLocalClientCommService.run: Start.");
        CenterDto center = ApplicationRepository.center;
        EvpsLocalClient asnClient = new EvpsLocalClient(center, this.config, this.bootstrapFactory, this.evpsLocalClientPacketInboundHandler, this.evpsLocalClientEncoder);
        this.clientTasks.add(asnClient);
        try {
            List futures = this.executorService.invokeAll(this.clientTasks);
            log.info("EvpsLocalClientCommService.run: futures, {} EA.", (Object)futures.size());
        }
        catch (InterruptedException e) {
            log.error("EvpsLocalClientCommService.run: Exception: InterruptedException");
            Thread.currentThread().interrupt();
        }
        log.info("EvpsLocalClientCommService.run: ..End.");
    }

    public void shutdown() {
        CenterDto obj = ApplicationRepository.center;
        if (obj.getNetState().getChannel() != null) {
            obj.getNetState().getChannel().close();
        }
        this.bootstrapFactory.getEventLoopGroup().shutdownGracefully();
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public ApplicationRepository getRepo() {
        return this.repo;
    }

    public EvpsLocalClientPacketInboundHandler getEvpsLocalClientPacketInboundHandler() {
        return this.evpsLocalClientPacketInboundHandler;
    }

    public EvpsLocalClientEncoder getEvpsLocalClientEncoder() {
        return this.evpsLocalClientEncoder;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public List<EvpsLocalClient> getClientTasks() {
        return this.clientTasks;
    }

    public EvpsLocalClientBootstrapFactory getBootstrapFactory() {
        return this.bootstrapFactory;
    }

    public EvpsLocalClientCommService(ApplicationConfig config, ApplicationRepository repo, EvpsLocalClientPacketInboundHandler evpsLocalClientPacketInboundHandler, EvpsLocalClientEncoder evpsLocalClientEncoder) {
        this.config = config;
        this.repo = repo;
        this.evpsLocalClientPacketInboundHandler = evpsLocalClientPacketInboundHandler;
        this.evpsLocalClientEncoder = evpsLocalClientEncoder;
    }
}

