/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.xnet.server.process.work;

import com.evps.comm.server.config.ThreadPoolInitializer;
import com.evps.comm.server.kafka.KafkaProducerService;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.comm.server.xnet.server.process.response.EvpsEvent;
import com.evps.comm.server.xnet.server.process.response.EvpsNetPing;
import com.evps.comm.server.xnet.server.process.response.EvpsNode;
import com.evps.comm.server.xnet.server.process.response.EvpsService;
import com.evps.comm.server.xnet.server.process.response.EvpsServiceEnd;
import com.evps.comm.server.xnet.server.process.response.EvpsSignal;
import com.evps.comm.server.xnet.server.process.work.DataPacketAsyncTask;
import com.evps.comm.server.xnet.server.process.work.DataPacketProcess;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.protocol.eEvpsOpCode;
import com.evps.common.protocol.response.RecvPacketDto;
import com.evps.common.utils.EvpsUtils;
import com.its.common.spring.SpringUtils;
import io.netty.channel.Channel;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class DataPacketProcess {
    private static final Logger log = LoggerFactory.getLogger(DataPacketProcess.class);
    private final LinkedBlockingQueue<RecvPacketDto> dataQueue = new LinkedBlockingQueue(2000);
    private final ThreadPoolExecutor taskExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    private final DataPacketAsyncTask asyncTask;
    private final DbmsDataProcess dbmsDataProcess;
    private final KafkaProducerService kafkaProducerService;

    public void run() {
        log.info("DataPacketProcess.run: Start.");
        ThreadPoolInitializer poolInitializer = (ThreadPoolInitializer)SpringUtils.getBean(ThreadPoolInitializer.class);
        int executePool = poolInitializer.getWork();
        for (int ii = 0; ii < executePool; ++ii) {
            log.info("DataPacketProcess.Task: Idx: {}.", (Object)ii);
            this.taskExecutor.execute(() -> {
                boolean isRunning = true;
                while (isRunning) {
                    try {
                        RecvPacketDto data = (RecvPacketDto)this.dataQueue.take();
                        this.asyncTask.run(this, data);
                    }
                    catch (Exception e) {
                        log.error("DataPacketProcess.Task: Exception: {}, {}", new Object[]{Thread.currentThread().getName(), e.getMessage(), e});
                        Thread.currentThread().interrupt();
                        isRunning = false;
                    }
                }
            });
        }
        log.info("DataPacketProcess.run: ..End.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(RecvPacketDto packet) {
        boolean isError = false;
        Channel channel = packet.getCenter().getNetState().getChannel();
        EvpsCenter center = packet.getCenter();
        eEvpsOpCode opCode = eEvpsOpCode.getValue((byte)packet.getPacket().getOpCode());
        try {
            MDC.put((String)"id", (String)center.getLogKey());
            EvpsService response = null;
            switch (1.$SwitchMap$com$evps$common$protocol$eEvpsOpCode[opCode.ordinal()]) {
                case 1: {
                    response = new EvpsService(this.dbmsDataProcess, this.kafkaProducerService);
                    break;
                }
                case 2: {
                    response = new EvpsNode(this.dbmsDataProcess, this.kafkaProducerService);
                    break;
                }
                case 3: {
                    response = new EvpsSignal(this.dbmsDataProcess, this.kafkaProducerService);
                    break;
                }
                case 4: {
                    response = new EvpsEvent(this.dbmsDataProcess, this.kafkaProducerService);
                    break;
                }
                case 5: {
                    response = new EvpsServiceEnd(this.dbmsDataProcess, this.kafkaProducerService);
                    break;
                }
                case 6: {
                    response = new EvpsNetPing(this.dbmsDataProcess, this.kafkaProducerService);
                }
            }
            if (response != null) {
                if (!response.response(packet)) {
                    isError = true;
                }
                log.info("[{}]. Service Id: {}, {} END: {}, {}", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), opCode, !isError, EvpsUtils.serviceEndString()});
            } else {
                log.error("[{}]. DataPacketProcess.process: Service Id: {}, Unknown packet cmd: {}. will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), opCode});
                isError = true;
            }
        }
        catch (Exception e) {
            log.error("[{}]. DataPacketProcess.process: Service Id: {}, Exception, will be closed. {}", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), e.getMessage()});
            isError = true;
        }
        finally {
            MDC.remove((String)center.getLogKey());
            MDC.clear();
        }
        if (isError) {
            log.error("[{}]. DataPacketProcess.process: Service Id: {}, cmd: {}. Processing failed. will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), opCode});
            ApplicationRepository.closeChannel((EvpsCenter)center, (Channel)channel);
        }
    }

    public boolean add(RecvPacketDto data) {
        boolean offer = false;
        try {
            offer = this.dataQueue.offer(data);
            if (!offer) {
                log.error("DataPacketProcess.add: Queue Full Error, Size: {} EA", (Object)this.dataQueue.size());
            }
        }
        catch (Exception e) {
            log.error("DataPacketProcess.add: Exception: {}", (Object)e.getMessage(), (Object)e);
        }
        return offer;
    }

    public DataPacketProcess(DataPacketAsyncTask asyncTask, DbmsDataProcess dbmsDataProcess, KafkaProducerService kafkaProducerService) {
        this.asyncTask = asyncTask;
        this.dbmsDataProcess = dbmsDataProcess;
        this.kafkaProducerService = kafkaProducerService;
    }
}

