/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.dao.mapper.batch;

import com.evps.comm.server.dao.mapper.BatchDaoService;
import com.evps.common.kafka.dto.EvpsNodeInfo;
import com.evps.common.kafka.dto.EvpsPhaseInfo;
import com.evps.common.kafka.dto.EvpsRouteInfo;
import com.evps.common.kafka.dto.EvpsSignalInfo;
import com.evps.common.kafka.dto.KafkaEvpsNodeDto;
import com.evps.common.kafka.dto.KafkaEvpsPhaseDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.kafka.dto.KafkaEvpsSignalDto;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class EvpCommServerDao
extends BatchDaoService {
    private static final Logger log = LoggerFactory.getLogger(EvpCommServerDao.class);

    public EvpCommServerDao(SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
        this.serviceName = "EvpCommServerDao";
    }

    public int insertEvpRoute(List<HashMap<String, Object>> req) {
        int total = this.insertBatch("insertEvpRoute", req);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertEvpRouteBatch(KafkaEvpsServiceDto service) {
        List routeList = service.getRouteList();
        int total = routeList.size();
        if (total == 0) {
            log.warn("{}.insertEvpRouteBatch: No Data. Service Id: {}.", (Object)this.serviceName, (Object)service.getServiceId());
            return 0;
        }
        int jobCnt = 0;
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            for (EvpsRouteInfo route : routeList) {
                sqlSession.insert("insertEvpRouteBatch", (Object)route);
                this.getClass();
                if (++jobCnt % 1000 != 0 && jobCnt != total) continue;
                sqlSession.flushStatements();
                sqlSession.clearCache();
            }
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.close();
            }
        }
        this.count = total;
        return this.count;
    }

    public int insertEvpNode(List<HashMap<String, Object>> req) {
        int total = this.insertBatch("insertEvpNode", req);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertEvpNodeBatch(KafkaEvpsNodeDto nodeDto) {
        List nodeList = nodeDto.getNodeList();
        int total = nodeList.size();
        if (total == 0) {
            log.warn("{}.insertEvpNodeBatch: No Data. Service Id: {}.", (Object)this.serviceName, (Object)nodeDto.getServiceId());
            return 0;
        }
        int jobCnt = 0;
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            for (EvpsNodeInfo node : nodeList) {
                sqlSession.insert("insertEvpNodeBatch", (Object)node);
                this.getClass();
                if (++jobCnt % 1000 != 0 && jobCnt != total) continue;
                sqlSession.flushStatements();
                sqlSession.clearCache();
            }
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.close();
            }
        }
        this.count = total;
        return this.count;
    }

    public int insertEvpPhase(List<HashMap<String, Object>> req) {
        int total = this.insertBatch("insertEvpPhase", req);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertEvpPhaseBatch(KafkaEvpsPhaseDto phaseDto) {
        List phaseList = phaseDto.getPhaseList();
        int total = phaseList.size();
        if (total == 0) {
            log.warn("{}.insertEvpPhaseBatch: No Data. Service Id: {}.", (Object)this.serviceName, (Object)phaseDto.getServiceId());
            return 0;
        }
        int jobCnt = 0;
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            for (EvpsPhaseInfo phase : phaseList) {
                sqlSession.insert("insertEvpPhaseBatch", (Object)phase);
                this.getClass();
                if (++jobCnt % 1000 != 0 && jobCnt != total) continue;
                sqlSession.flushStatements();
                sqlSession.clearCache();
            }
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.close();
            }
        }
        this.count = total;
        return this.count;
    }

    public int insertEvpSignal(List<HashMap<String, Object>> req) {
        int total = this.insertBatch("insertEvpSignal", req);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertEvpSignalBatch(KafkaEvpsSignalDto signalDto) {
        List phaseList = signalDto.getSignalList();
        int total = phaseList.size();
        if (total == 0) {
            log.warn("{}.insertEvpSignalBatch: No Data. Service Id: {}.", (Object)this.serviceName, (Object)signalDto.getServiceId());
            return 0;
        }
        int jobCnt = 0;
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            for (EvpsSignalInfo signal : phaseList) {
                sqlSession.insert("insertEvpSignalBatch", (Object)signal);
                this.getClass();
                if (++jobCnt % 1000 != 0 && jobCnt != total) continue;
                sqlSession.flushStatements();
                sqlSession.clearCache();
            }
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.close();
            }
        }
        this.count = total;
        return this.count;
    }

    public int insertEvpSignalCurr(List<HashMap<String, Object>> req) {
        int total = this.insertBatch("insertEvpSignalCurr", req);
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertEvpSignalCurrBatch(KafkaEvpsSignalDto signalDto) {
        List phaseList = signalDto.getSignalList();
        int total = phaseList.size();
        if (total == 0) {
            log.warn("{}.insertEvpSignalCurrBatch: No Data. Service Id: {}.", (Object)this.serviceName, (Object)signalDto.getServiceId());
            return 0;
        }
        int jobCnt = 0;
        SqlSession sqlSession = null;
        try {
            sqlSession = this.sqlSessionFactory.openSession(ExecutorType.BATCH, false);
            for (EvpsSignalInfo signal : phaseList) {
                sqlSession.insert("insertEvpSignalCurrBatch", (Object)signal);
                this.getClass();
                if (++jobCnt % 1000 != 0 && jobCnt != total) continue;
                sqlSession.flushStatements();
                sqlSession.clearCache();
            }
        }
        finally {
            if (sqlSession != null) {
                sqlSession.commit();
                sqlSession.close();
            }
        }
        this.count = total;
        return this.count;
    }
}

