/*
 * Decompiled with CFR 0.152.
 */
package com.evps.simulator.kafka.producer.service;

import com.evps.common.kafka.dto.KafkaEvpsEventDto;
import com.evps.common.kafka.dto.KafkaEvpsNodeDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceEndDto;
import com.evps.common.kafka.dto.KafkaEvpsSignalDto;
import com.evps.common.utils.EvpsUtils;
import com.evps.simulator.kafka.producer.config.ApplicationConfig;
import com.evps.simulator.kafka.producer.kafka.KafkaProducerService;
import com.evps.simulator.kafka.producer.service.EvpsKafkaSimGen;
import com.its.common.utils.Elapsed;
import com.its.common.utils.TimeUtils;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EvpsKafkaProducerManagerService {
    private static final Logger log = LoggerFactory.getLogger(EvpsKafkaProducerManagerService.class);
    private final ApplicationConfig config;
    private final KafkaProducerService kafkaProducerService;
    private boolean isRunning = false;

    @PostConstruct
    private void init() {
        this.isRunning = false;
    }

    public void run() {
        if (this.isRunning) {
            log.warn("EvpsKafkaProducerManagerService: Already running....................");
            return;
        }
        this.isRunning = true;
        Elapsed elapsed = new Elapsed();
        EvpsKafkaSimGen simGenData = new EvpsKafkaSimGen(this.config.getRegionId(), "\ub300\uc885\ub85c \uc0ac\uac70\ub9ac", "74\ubb345035", 2);
        simGenData.makeEvpsKafkaSimulatorData();
        KafkaEvpsServiceDto serviceDto = simGenData.getServiceStartDto();
        serviceDto.setClctDt(EvpsUtils.getClctDt());
        this.kafkaProducerService.sendEvpsServiceTopic(serviceDto);
        KafkaEvpsNodeDto nodeDto = simGenData.getEvpsNodeDto();
        nodeDto.setClctDt(EvpsUtils.getClctDt());
        this.kafkaProducerService.sendEvpsNodeTopic(nodeDto);
        for (int ii = 0; ii < simGenData.getListSignalDto().size(); ++ii) {
            TimeUtils.sleep((long)1000L);
            KafkaEvpsSignalDto signalDto = (KafkaEvpsSignalDto)simGenData.getListSignalDto().get(ii);
            signalDto.setClctDt(EvpsUtils.getClctDt());
            this.kafkaProducerService.sendEvpsSignalTopic(signalDto);
            KafkaEvpsEventDto eventDto = (KafkaEvpsEventDto)simGenData.getListEventDto().get(ii);
            eventDto.setClctDt(EvpsUtils.getClctDt());
            this.kafkaProducerService.sendEvpsEventTopic(eventDto);
        }
        KafkaEvpsServiceEndDto endDto = simGenData.getServiceEndDto();
        endDto.setClctDt(EvpsUtils.getClctDt());
        this.kafkaProducerService.sendEvpsServiceEndTopic(endDto);
        log.info("EvpsKafkaProducerManagerService: Run completed. {}", (Object)elapsed.elapsedTimeStr());
        this.isRunning = false;
    }

    public EvpsKafkaProducerManagerService(ApplicationConfig config, KafkaProducerService kafkaProducerService) {
        this.config = config;
        this.kafkaProducerService = kafkaProducerService;
    }
}

