/*
 * Decompiled with CFR 0.152.
 */
package com.evps.simulator.kafka.producer.service;

import com.evps.common.kafka.dto.EvpsNodeInfo;
import com.evps.common.kafka.dto.EvpsPhaseInfo;
import com.evps.common.kafka.dto.EvpsRouteInfo;
import com.evps.common.kafka.dto.EvpsSignalInfo;
import com.evps.common.kafka.dto.KafkaEvpsEventDto;
import com.evps.common.kafka.dto.KafkaEvpsNodeDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceEndDto;
import com.evps.common.kafka.dto.KafkaEvpsSignalDto;
import com.evps.common.utils.EvpsUtils;
import com.its.common.utils.StringUtils;
import com.its.common.utils.TimeUtils;
import java.util.ArrayList;
import java.util.List;

public class EvpsKafkaSimGen {
    private String regionId;
    private String serviceName;
    private String vehNo;
    private String serviceId;
    private int serviceEndReason;
    private KafkaEvpsServiceDto serviceStartDto;
    private KafkaEvpsServiceEndDto serviceEndDto;
    private KafkaEvpsNodeDto evpsNodeDto;
    private List<KafkaEvpsEventDto> listEventDto = new ArrayList();
    private List<KafkaEvpsSignalDto> listSignalDto = new ArrayList();

    public EvpsKafkaSimGen(String regionId, String serviceName, String vehNo, int endReason) {
        this.regionId = regionId;
        this.serviceName = serviceName;
        this.vehNo = vehNo;
        this.serviceEndReason = endReason;
    }

    public void makeEvpsKafkaSimulatorData() {
        this.serviceId = this.regionId + TimeUtils.getCurrentTimeString() + "00";
        this.makeServiceData();
        this.makeServiceEndData();
        this.makeNodeData();
        this.makeEventData();
        this.makeSignalData();
    }

    private void makeServiceData() {
        String clctDt = EvpsUtils.getClctDt();
        this.serviceStartDto = KafkaEvpsServiceDto.builder().serviceId(this.serviceId).clctDt(clctDt).evNo(this.vehNo).curLat(Double.valueOf(36.33936)).curLng(Double.valueOf(127.437125)).serviceNm(this.serviceName).arrLat(Double.valueOf(36.333643)).arrLng(Double.valueOf(127.419731)).arrTm(Integer.valueOf(10)).vehLen(Integer.valueOf(0)).ocrNo("").ocrType("").serviceDist(Integer.valueOf(2000)).curSpd(Integer.valueOf(4)).statusCd(Integer.valueOf(1)).routeList(new ArrayList()).build();
        double[] lat = new double[]{36.339461, 36.340669, 36.339514, 36.338898, 36.338124, 36.33652, 36.33588, 36.334927, 36.333643};
        double[] lng = new double[]{127.436902, 127.436004, 127.433575, 127.431836, 127.429608, 127.426063, 127.424589, 127.422482, 127.419731};
        for (int ii = 0; ii < lat.length; ++ii) {
            EvpsRouteInfo route = EvpsRouteInfo.builder().serviceId(this.serviceId).clctDt(clctDt).seqNo(Integer.valueOf(ii + 1)).lat(lat[ii]).lng(lng[ii]).build();
            this.serviceStartDto.getRouteList().add(route);
        }
    }

    private void makeServiceEndData() {
        String clctDt = EvpsUtils.getClctDt();
        this.serviceEndDto = KafkaEvpsServiceEndDto.builder().serviceId(this.serviceId).clctDt(clctDt).reason(Integer.valueOf(this.serviceEndReason)).build();
    }

    private void makeNodeData() {
        String clctDt = EvpsUtils.getClctDt();
        this.evpsNodeDto = KafkaEvpsNodeDto.builder().serviceId(this.serviceId).clctDt(clctDt).nodeList(new ArrayList()).build();
        long[] nodeIdArr = new long[]{1382L, 96L, 97L, 735L, 238L, 98L, 667L, 510L, 439L};
        String[] nodeNm = new String[]{"\ub3d9\ubd80\uc18c\ubc29\uc11c\uc0bc\uac70\ub9ac-ppc\uc5c5-\uc8fc\ub85c\uc0ac\uc6a9\ud568", "\uc131\ub0a8\ub124\uac70\ub9ac-ppc\uc5c5", "\uacc4\ub8e1\uacf5\uace0\uc0bc\uac70\ub9ac", "\ud734\uba3c\uc13c\ud0c0\ub124\uac70\ub9ac", "\uc0bc\uc131\ub124\uac70\ub9ac", "\ud55c\ubc2d\uc911\ub124\uac70\ub9ac", "\ubcf4\ubb38\uc911(\ub2e8)", "\uc0bc\uc120\uad50\ub124\uac70\ub9ac(3)-\uacf5\uc0ac\uc911", "\ub300\uc885\ub85c\ub124\uac70\ub9ac"};
        double[] lat = new double[]{36.339461, 36.340669, 36.339514, 36.338898, 36.338124, 36.33652, 36.33588, 36.334927, 36.333643};
        double[] lng = new double[]{127.436902, 127.436004, 127.433575, 127.431836, 127.429608, 127.426063, 127.424589, 127.422482, 127.419731};
        int[][] ring = new int[][]{{1, 1, 2, 2}, {1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2}, {1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2}, {1, 1, 1, 1, 2, 2, 2, 2}, {1, 1, 1, 1, 2, 2, 2, 2}, {1, 1, 1, 1, 2, 2, 2, 2}, {1, 2}, {1, 1, 1, 2, 2, 2}, {1, 1, 1, 1, 2, 2, 2, 2}};
        int[][] planClass = new int[][]{{1, 1, 1, 1}, {1, 1, 1, 1, 6, 6, 6, 6, 1, 1, 1, 1, 6, 6, 6, 6}, {1, 1, 1, 1, 6, 6, 6, 1, 1, 1, 6, 6, 6}, {1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1}, {1, 1}, {1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1}};
        int[][] phaseNo = new int[][]{{1, 2, 1, 2}, {1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4}, {2, 3, 4, 5, 1, 2, 3, 1, 2, 3, 1, 2, 3}, {1, 2, 3, 4, 1, 2, 3, 5}, {1, 2, 3, 4, 1, 2, 3, 4}, {1, 2, 3, 4, 1, 2, 3, 4}, {2, 2}, {1, 2, 3, 1, 2, 3}, {1, 2, 3, 4, 1, 2, 3, 4}};
        int[][] flowNo = new int[][]{{8, 8, 4, 4}, {8, 5, 7, 6, 8, 5, 4, 1, 3, 2, 4, 1, 3, 2, 7, 6}, {6, 6, 6, 6, 3, 6, 6, 3, 2, 2, 3, 2, 2}, {5, 6, 6, 7, 2, 2, 1, 3}, {8, 6, 5, 7, 3, 1, 2, 4}, {5, 6, 8, 7, 2, 1, 3, 4}, {6, 2}, {7, 6, 6, 4, 2, 2}, {6, 5, 8, 7, 1, 2, 3, 4}};
        double[][] headLat = new double[][]{{36.339211, 36.339211, 36.339698, 36.339698}, {36.340433, 36.340571, 36.340997, 36.34091, 36.340433, 36.340571, 36.340928, 36.340772, 36.340349, 36.340432, 36.340928, 36.340772, 36.340349, 36.340432, 36.340997, 36.34091}, {36.339743, 36.339743, 36.339743, 36.339743, 36.33921, 36.339743, 36.339743, 36.33921, 36.33931, 36.33931, 36.33921, 36.33931, 36.33931}, {36.338844, 36.339102, 36.339102, 36.339225, 36.338695, 36.338695, 36.338954, 36.338578}, {36.337844, 36.338326, 36.338036, 36.338399, 36.33779, 36.338177, 36.337894, 36.338278}, {36.336438, 36.336749, 36.33634, 36.336813, 36.336295, 36.336608, 36.336229, 36.336703}, {36.336105, 36.335651}, {36.33525, 36.335156, 36.335156, 36.335172, 36.334698, 36.334698}, {36.333471, 36.333928, 36.333326, 36.333739, 36.333356, 36.333812, 36.333413, 36.333878}};
        double[][] headLng = new double[][]{{127.437176, 127.437176, 127.436609, 127.436609}, {127.436297, 127.435609, 127.435923, 127.436291, 127.436297, 127.435609, 127.435742, 127.436397, 127.436125, 127.435712, 127.435742, 127.436397, 127.436125, 127.435712, 127.435923, 127.436291}, {127.433876, 127.433876, 127.433876, 127.433876, 127.433748, 127.433876, 127.433876, 127.433748, 127.433247, 127.433247, 127.433748, 127.433247, 127.433247}, {127.431428, 127.432163, 127.432163, 127.431749, 127.431507, 127.431507, 127.432244, 127.43196}, {127.429835, 127.429937, 127.429209, 127.429374, 127.429646, 127.430016, 127.429307, 127.429241}, {127.425662, 127.426365, 127.426412, 127.425863, 127.425757, 127.426462, 127.426266, 127.425717}, {127.424895, 127.424288}, {127.422377, 127.422783, 127.422783, 127.422201, 127.42218, 127.42218}, {127.420085, 127.419514, 127.4196, 127.420128, 127.419943, 127.419374, 127.419431, 127.420026}};
        double[][] midLat = new double[][]{{36.339499, 36.339499, 36.33942, 36.33942}, {36.340711, 36.340739, 36.340704, 36.340738, 36.340711, 36.340739, 36.340634, 36.3406, 36.340627, 36.3406, 36.340634, 36.3406, 36.340627, 36.3406, 36.340704, 36.340738}, {36.339585, 36.339585, 36.339585, 36.339585, 36.339463, 36.339585, 36.339585, 36.339463, 36.33944, 36.33944, 36.339463, 36.33944, 36.33944}, {36.338972, 36.338972, 36.338972, 36.338933, 36.338823, 36.338823, 36.338823, 36.338855}, {36.33815, 36.338198, 36.338194, 36.338184, 36.338097, 36.338049, 36.338053, 36.338063}, {36.336592, 36.336591, 36.336576, 36.336576, 36.336449, 36.336449, 36.336464, 36.336465}, {36.335951, 36.335809}, {36.334966, 36.334998, 36.334998, 36.334888, 36.334856, 36.334856}, {36.333701, 36.333702, 36.3336, 36.333574, 36.333586, 36.333585, 36.333687, 36.333713}};
        double[][] midLng = new double[][]{{127.436991, 127.436991, 127.436816, 127.436816}, {127.43609, 127.435952, 127.436095, 127.435951, 127.43609, 127.435952, 127.435913, 127.436057, 127.435918, 127.436056, 127.435913, 127.436057, 127.435918, 127.436056, 127.436095, 127.435951}, {127.433526, 127.433526, 127.433526, 127.433526, 127.433496, 127.433526, 127.433526, 127.433496, 127.433615, 127.433615, 127.433496, 127.433615, 127.433615}, {127.431796, 127.431796, 127.431796, 127.431926, 127.431875, 127.431875, 127.431876, 127.43175}, {127.429702, 127.429568, 127.429559, 127.429674, 127.429513, 127.429647, 127.429657, 127.429541}, {127.426016, 127.426014, 127.426136, 127.426137, 127.426111, 127.426112, 127.42599, 127.42599}, {127.424541, 127.424638}, {127.42257, 127.422433, 127.422433, 127.422394, 127.422531, 127.422531}, {127.419802, 127.419801, 127.419816, 127.419782, 127.41966, 127.419661, 127.419647, 127.41968}};
        double[][] endLat = new double[][]{{36.339785, 36.339785, 36.339124, 36.339124}, {36.341013, 36.34104, 36.34088, 36.340566, 36.341013, 36.34104, 36.340349, 36.340315, 36.340455, 36.340776, 36.340349, 36.340315, 36.340455, 36.340776, 36.34088, 36.340566}, {36.339451, 36.339451, 36.339451, 36.339451, 36.339329, 36.339451, 36.339451, 36.339329, 36.339602, 36.339602, 36.339329, 36.339602, 36.339602}, {36.339272, 36.33884, 36.33884, 36.339067, 36.338957, 36.338957, 36.338539, 36.338724}, {36.338371, 36.338035, 36.338415, 36.338316, 36.337934, 36.337734, 36.338184, 36.337748}, {36.336836, 36.336433, 36.33682, 36.336738, 36.336611, 36.336207, 36.336307, 36.336223}, {36.335789, 36.335967}, {36.335129, 36.334835, 36.334835, 36.334595, 36.335019, 36.335019}, {36.333934, 36.333871, 36.333769, 36.333337, 36.333305, 36.333349, 36.33392, 36.333432}};
        double[][] endLng = new double[][]{{127.436778, 127.436778, 127.437006, 127.437006}, {127.435913, 127.435776, 127.436445, 127.435598, 127.435913, 127.435776, 127.436126, 127.436269, 127.435565, 127.436406, 127.436126, 127.436269, 127.435565, 127.436406, 127.436445, 127.435598}, {127.433148, 127.433148, 127.433148, 127.433148, 127.433119, 127.433148, 127.433148, 127.433119, 127.433975, 127.433975, 127.433119, 127.433975, 127.433975}, {127.431615, 127.431417, 127.431417, 127.432304, 127.432253, 127.432253, 127.432091, 127.431372}, {127.429394, 127.429208, 127.42925, 127.430053, 127.429153, 127.429784, 127.430036, 127.429678}, {127.425735, 127.425651, 127.425855, 127.426497, 127.426471, 127.426396, 127.425627, 127.426273}, {127.424182, 127.425001}, {127.42293, 127.422073, 127.422073, 127.422592, 127.422891, 127.422891}, {127.419507, 127.420156, 127.420171, 127.420073, 127.419439, 127.419952, 127.419352, 127.419459}};
        int[][] headAngle = new int[][]{{62, 62, 239, 239}, {59, 148, 244, 327, 59, 148, 244, 327, 59, 148, 244, 327, 59, 148, 244, 327}, {330, 330, 330, 330, 51, 330, 330, 51, 156, 156, 51, 156, 156}, {156, 336, 336, 243, 156, 156, 336, 58}, {70, 336, 150, 221, 70, 336, 150, 221}, {151, 330, 46, 227, 151, 330, 46, 227}, {331, 150}, {241, 330, 330, 241, 150, 150}, {45, 224, 122, 329, 45, 224, 122, 329}};
        int[][] endAngle = new int[][]{{59, 59, 242, 242}, {64, 64, 147, 328, 64, 64, 239, 239, 328, 147, 239, 239, 328, 147, 147, 328}, {336, 336, 336, 336, 336, 336, 336, 336, 150, 150, 336, 150, 150}, {63, 336, 336, 156, 156, 156, 238, 336}, {41, 330, 41, 156, 330, 250, 156, 250}, {47, 331, 47, 150, 150, 226, 331, 226}, {330, 151}, {150, 330, 330, 241, 150, 150}, {44, 149, 149, 225, 302, 225, 44, 302}};
        for (int ii = 0; ii < nodeIdArr.length; ++ii) {
            int seqNo = ii + 1;
            long nodeId = nodeIdArr[ii];
            EvpsNodeInfo node = EvpsNodeInfo.builder().serviceId(this.serviceId).clctDt(clctDt).seqNo(Integer.valueOf(seqNo)).nodeId(Long.valueOf(nodeId)).nodeNm(nodeNm[ii]).lat(lat[ii]).lng(lng[ii]).phaseList(new ArrayList()).build();
            for (int jj = 0; jj < ring[ii].length; ++jj) {
                EvpsPhaseInfo phase = EvpsPhaseInfo.builder().serviceId(this.serviceId).clctDt(clctDt).seqNo(Integer.valueOf(seqNo)).nodeId(Long.valueOf(nodeId)).ring(Integer.valueOf(ring[ii][jj])).planClass(Integer.valueOf(planClass[ii][jj])).phaseNo(Integer.valueOf(phaseNo[ii][jj])).flowNo(Integer.valueOf(flowNo[ii][jj])).headLat(Double.valueOf(headLat[ii][jj])).headLng(Double.valueOf(headLng[ii][jj])).midLat(Double.valueOf(midLat[ii][jj])).midLng(Double.valueOf(midLng[ii][jj])).endLat(Double.valueOf(endLat[ii][jj])).endLng(Double.valueOf(endLng[ii][jj])).headAngle(Integer.valueOf(headAngle[ii][jj])).endAngle(Integer.valueOf(endAngle[ii][jj])).build();
                node.getPhaseList().add(phase);
            }
            this.evpsNodeDto.getNodeList().add(node);
        }
    }

    private void makeEventData() {
        double[] curLat = new double[]{36.339345, 36.339345, 36.339445, 36.339445, 36.339541, 36.339541, 36.339604, 36.339604, 36.339705, 36.339778, 36.339778, 36.339835, 36.339835, 36.339903, 36.339903, 36.340048, 36.340048, 36.340115, 36.340115, 36.34017, 36.34017, 36.340233, 36.340318, 36.340318, 36.340397, 36.340397, 36.340466, 36.340466, 36.3405, 36.3405, 36.34054, 36.34054, 36.340554, 36.340554, 36.340599, 36.340644, 36.340644, 36.340661, 36.340661, 36.340652, 36.340652, 36.340659, 36.340659, 36.340663, 36.340663, 36.340677, 36.340677, 36.340685, 36.340685, 36.340681, 36.340669, 36.340667, 36.340667, 36.34067, 36.34067, 36.340677, 36.340677, 36.340677, 36.340677, 36.340673, 36.340673, 36.340703, 36.340713, 36.340711, 36.340711, 36.340707, 36.340707, 36.340693, 36.340693, 36.340684, 36.340684, 36.340691, 36.340691, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340688, 36.340697, 36.340697, 36.340697, 36.340697, 36.340697, 36.340697, 36.340697, 36.340697, 36.340697, 36.340697, 36.340697, 36.340697, 36.340697, 36.340697, 36.34073, 36.34073, 36.340763, 36.340763, 36.340753, 36.340753, 36.340738, 36.340738, 36.340706, 36.340706, 36.340645, 36.340645, 36.340597, 36.340597, 36.34054, 36.340482, 36.340482, 36.340428, 36.340428, 36.34037, 36.340308, 36.340308, 36.340187, 36.340127, 36.340127, 36.340046, 36.340046, 36.339983, 36.339983, 36.339917, 36.339917, 36.339858, 36.339798, 36.339798, 36.339741, 36.339741, 36.339671, 36.339671, 36.339609, 36.339609, 36.339561, 36.339561, 36.339516, 36.339466, 36.339466, 36.339417, 36.339417, 36.339324, 36.339324, 36.339209, 36.339209, 36.339155, 36.339107, 36.339053, 36.339053, 36.338942, 36.338942, 36.338773, 36.338773, 36.338423, 36.338286, 36.338236, 36.338155, 36.338155, 36.338099, 36.338099, 36.338072, 36.338028, 36.337952, 36.337895, 36.337838, 36.337786, 36.337786, 36.337713, 36.337713, 36.33765, 36.337609, 36.337567, 36.337567, 36.337533, 36.337533, 36.337482, 36.337482, 36.337386, 36.337347, 36.337305, 36.337282, 36.337223, 36.337223, 36.337163, 36.337141, 36.337141, 36.33711, 36.3371, 36.3371, 36.33707, 36.33707, 36.336942, 36.336815, 36.336741, 36.336635, 36.336575, 36.336575, 36.33647, 36.336423, 36.336423, 36.336321, 36.33624, 36.33624, 36.336168, 36.336094, 36.336019, 36.335947, 36.335875, 36.335793, 36.335551, 36.335416, 36.335377, 36.335321, 36.335258, 36.335096, 36.335038, 36.334995, 36.334969, 36.334934, 36.334902, 36.334841, 36.334794, 36.334747, 36.334711, 36.334658, 36.334607, 36.334556, 36.334493, 36.334431, 36.334379, 36.33432, 36.334259, 36.334185, 36.334125, 36.334072, 36.334072, 36.333962, 36.333916, 36.33382, 36.333706, 36.333613, 36.333564, 36.333515, 36.333515, 36.333517, 36.333432, 36.333372, 36.333235, 36.333235, 36.331621, 36.331584, 36.33156, 36.3316, 36.331659, 36.331729, 36.331729, 36.331826, 36.331902, 36.331951, 36.331993, 36.331988, 36.332042, 36.332042, 36.332054};
        double[] curLng = new double[]{127.437077, 127.437077, 127.436934, 127.436934, 127.436888, 127.436888, 127.436837, 127.436837, 127.436779, 127.43672, 127.43672, 127.436683, 127.436683, 127.436654, 127.436654, 127.436551, 127.436551, 127.436503, 127.436503, 127.436463, 127.436463, 127.436436, 127.436361, 127.436361, 127.436315, 127.436315, 127.436262, 127.436262, 127.436228, 127.436228, 127.436217, 127.436217, 127.436208, 127.436208, 127.436168, 127.436137, 127.436137, 127.436125, 127.436125, 127.436126, 127.436126, 127.436119, 127.436119, 127.436103, 127.436103, 127.436089, 127.436089, 127.4361, 127.4361, 127.436111, 127.4361, 127.436089, 127.436089, 127.43607, 127.43607, 127.436046, 127.436046, 127.436021, 127.436021, 127.436007, 127.436007, 127.43604, 127.436066, 127.436095, 127.436095, 127.436107, 127.436107, 127.436109, 127.436109, 127.436114, 127.436114, 127.436123, 127.436123, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.436135, 127.43614, 127.43614, 127.43614, 127.43614, 127.43614, 127.43614, 127.43614, 127.43614, 127.43614, 127.43614, 127.43614, 127.43614, 127.43614, 127.43614, 127.43605, 127.43605, 127.435978, 127.435978, 127.435887, 127.435887, 127.435802, 127.435802, 127.4357, 127.4357, 127.43562, 127.43562, 127.435524, 127.435524, 127.435427, 127.435316, 127.435316, 127.435204, 127.435204, 127.435067, 127.43493, 127.43493, 127.434689, 127.434543, 127.434543, 127.434411, 127.434411, 127.434288, 127.434288, 127.43416, 127.43416, 127.434037, 127.433911, 127.433911, 127.433785, 127.433785, 127.433667, 127.433667, 127.433551, 127.433551, 127.433416, 127.433416, 127.433284, 127.433154, 127.433154, 127.433024, 127.433024, 127.432739, 127.432739, 127.432451, 127.432451, 127.432279, 127.432107, 127.431936, 127.431936, 127.431571, 127.431571, 127.430997, 127.430997, 127.430063, 127.429824, 127.429691, 127.429571, 127.429571, 127.429475, 127.429475, 127.429322, 127.429204, 127.429082, 127.42895, 127.428817, 127.428677, 127.428677, 127.428552, 127.428552, 127.428439, 127.428314, 127.428266, 127.428266, 127.428187, 127.428187, 127.428077, 127.428077, 127.427904, 127.427788, 127.427656, 127.427574, 127.427477, 127.427477, 127.427274, 127.427178, 127.427178, 127.427066, 127.426963, 127.426963, 127.426858, 127.426858, 127.426649, 127.42642, 127.426311, 127.426102, 127.425985, 127.425985, 127.425744, 127.425612, 127.425612, 127.425355, 127.425237, 127.425237, 127.425121, 127.42497, 127.424807, 127.424646, 127.424493, 127.424331, 127.423729, 127.423495, 127.423335, 127.423202, 127.423097, 127.422728, 127.422619, 127.422522, 127.422436, 127.422322, 127.422236, 127.422102, 127.421972, 127.421739, 127.421581, 127.421486, 127.421383, 127.421281, 127.421175, 127.42108, 127.420977, 127.420876, 127.420731, 127.420635, 127.420512, 127.420392, 127.420392, 127.420127, 127.420002, 127.419845, 127.419784, 127.419805, 127.419841, 127.419847, 127.419847, 127.419913, 127.420019, 127.420084, 127.420235, 127.420235, 127.422888, 127.4229, 127.422974, 127.423301, 127.423443, 127.423491, 127.423491, 127.423492, 127.423582, 127.423633, 127.423694, 127.423757, 127.423835, 127.423835, 127.423864};
        int[] speed = new int[]{20, 30, 30, 30, 40, 40, 40, 40, 40, 40, 30, 30, 40, 40, 50, 50, 50, 50, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 30, 30, 20, 20, 20, 20, 10, 5, 5, 5, 5};
        int[] distance = new int[]{1849, 1849, 1840, 1834, 1827, 1820, 1808, 1798, 1798, 1789, 1774, 1745, 1738, 1733, 1733, 1733, 1713, 1704, 1691, 1685, 1685, 1679, 1673, 1662, 1649, 1631, 1619, 1606, 1606, 1593, 1581, 1569, 1554, 1543, 1532, 1521, 1509, 1498, 1488, 1477, 1462, 1450, 1437, 1424, 1415, 1404, 1396, 1386, 1374, 1349, 1338, 1324, 1309, 1284, 1255, 1238, 1222, 1205, 1188, 1173, 1173, 1173, 1159, 1145, 1145, 1132, 1107, 1107, 1095, 1072, 1060, 1047, 1024, 1024, 1014, 1014, 1005, 994, 994, 985, 966, 966, 955, 947, 934, 923, 904, 904, 892, 892, 884, 884, 878, 866, 854, 854, 840, 840, 826, 812, 812, 799, 787, 773, 773, 762, 762, 748, 735, 709, 709, 709, 691, 691, 682, 682, 665, 649, 649, 649, 620, 620, 606, 606, 593, 593, 580, 568, 568, 554, 554, 542, 542, 529, 529, 516, 516, 503, 503, 503, 489, 489, 476, 476, 461, 461, 447, 421, 421, 407, 393, 393, 381, 381, 369, 369, 369, 359, 359, 349, 349, 340, 340, 332, 332, 324, 324, 316, 316, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 306, 306, 306, 306, 306, 306, 306, 306, 306, 306, 306, 306, 306, 306, 306, 306, 306, 306, 306, 305, 305, 304, 304, 303, 303, 301, 301, 300, 300, 298, 295, 291, 291, 289, 289, 287, 287, 285, 285, 283, 283, 282, 282, 281, 281, 280, 280, 278, 278, 276, 276, 275, 275, 274, 274, 272, 272, 266, 260, 260, 258, 258, 254, 254, 249, 249, 240, 240, 230, 230, 219, 219, 219, 212, 212, 203, 203, 195, 195, 187, 187, 180, 180, 170, 158, 158, 149, 149, 138, 138, 121, 121, 117};
        this.listEventDto = new ArrayList();
        String clctDt = EvpsUtils.getClctDt();
        for (int ii = 0; ii < curLat.length; ++ii) {
            int eventCd = ii == curLat.length - 1 ? 2 : 1;
            KafkaEvpsEventDto evpsEventDto = KafkaEvpsEventDto.builder().clctDt(clctDt).serviceId(this.serviceId).evNo(this.vehNo).eventCd(Integer.valueOf(eventCd)).curLat(Double.valueOf(curLat[ii])).curLng(Double.valueOf(curLng[ii])).curSpd(Integer.valueOf(speed[ii])).remDist(Integer.valueOf(distance[ii])).build();
            this.listEventDto.add(evpsEventDto);
        }
    }

    private void makeSignalData() {
        String[][] signalArr = new String[][]{{"22,1,1,2,2,0", "20,1,1,2,2,0", "20,1,1,2,2,0", "3,1,1,2,2,0", "3,1,1,2,2,0", "8,1,1,2,2,0", "8,1,1,2,2,0", "16,1,1,2,2,0", "16,1,1,2,2,0", "29,1,1,2,2,0", "38,1,1,2,2,0", "38,1,1,2,2,0", "45,1,1,2,2,0", "45,1,1,2,2,0", "53,1,1,2,2,0", "53,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0"}, {"176,1,1,2,2,0", "175,1,1,2,2,0", "175,1,1,2,2,0", "159,1,1,2,2,0", "159,1,1,2,2,0", "148,1,1,2,2,0", "148,1,1,2,2,0", "139,1,1,2,2,0", "139,1,1,2,2,0", "127,1,1,2,2,0", "117,1,1,2,2,0", "117,1,1,2,2,0", "110,1,1,2,2,0", "110,1,1,2,2,0", "103,1,1,2,2,0", "103,1,1,2,2,0", "84,1,1,2,2,0", "84,1,1,2,2,0", "76,1,1,2,2,0", "76,1,1,2,2,0", "69,1,1,2,2,0", "69,1,1,2,2,0", "61,1,1,2,2,0", "50,1,1,2,2,0", "50,1,1,2,2,0", "41,1,1,2,2,0", "41,1,1,3,3,0", "32,1,1,3,3,0", "32,1,1,3,3,0", "27,1,1,3,3,0", "27,1,1,3,3,0", "23,1,1,3,3,0", "23,1,1,3,3,0", "22,1,1,3,3,0", "22,1,1,3,3,0", "16,1,1,3,3,0", "12,1,1,3,3,0", "12,1,1,3,3,0", "10,1,1,3,3,0", "10,1,1,3,3,0", "11,1,1,3,3,0", "11,1,1,3,3,0", "10,1,1,3,3,0", "10,1,1,3,3,0", "8,1,1,3,3,0", "8,1,1,3,3,0", "7,1,1,3,3,0", "7,1,1,3,3,0", "8,1,1,3,3,0", "8,1,1,3,3,0", "9,1,1,3,3,0", "8,1,1,3,3,0", "7,1,1,3,3,0", "7,1,1,3,3,0", "5,1,1,3,3,0", "5,1,1,3,3,0", "3,1,1,3,3,0", "3,1,1,3,3,0", "1,1,1,3,3,0", "1,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "4,1,1,3,3,0", "7,1,1,4,4,0", "9,1,1,4,4,0", "9,1,1,4,4,0", "10,1,1,4,4,0", "10,1,1,4,4,0", "9,1,1,4,4,0", "9,1,1,4,4,0", "9,1,1,4,4,0", "9,1,1,4,4,0", "10,1,1,4,4,0", "10,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "11,1,1,4,4,0", "12,1,1,4,4,0", "12,1,1,4,4,0", "12,1,1,4,4,0", "12,1,1,4,4,0", "12,1,1,4,4,0", "12,1,1,4,4,0", "12,1,1,4,4,0", "12,1,1,4,4,0", "12,1,1,4,4,0", "12,1,1,1,1,0", "12,1,1,1,1,0", "12,1,1,1,1,0", "12,1,1,1,1,0", "12,1,1,1,1,0", "7,1,1,1,1,0", "7,1,1,1,1,0", "10,1,1,1,1,0", "10,1,1,1,1,0", "13,1,1,1,1,0", "13,1,1,1,1,0", "19,1,1,1,1,0", "19,1,1,1,1,0", "27,1,1,1,1,0", "27,1,1,1,1,0", "34,1,1,1,1,0", "34,1,1,1,1,0", "43,1,1,1,1,0", "43,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0"}, {"319,1,1,1,1,0", "314,1,1,1,1,0", "314,1,1,1,1,0", "301,5,1,1,1,2", "301,5,1,1,1,2", "297,5,1,1,1,2", "297,5,1,1,1,2", "292,5,1,1,1,2", "292,5,1,1,1,2", "288,5,1,1,1,2", "283,5,1,1,1,2", "283,5,1,1,1,2", "281,5,1,1,1,2", "281,5,1,1,1,2", "279,5,1,1,1,2", "279,5,1,1,1,2", "273,5,1,1,1,2", "273,5,1,1,1,2", "271,5,1,1,1,2", "271,5,1,1,1,2", "269,5,1,2,2,2", "269,5,1,2,2,2", "268,5,1,2,2,2", "265,5,1,2,2,2", "265,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "263,5,1,2,2,2", "263,5,1,2,2,2", "262,5,1,2,2,2", "262,5,1,2,2,2", "263,5,1,2,2,2", "263,5,1,2,2,2", "262,5,1,2,2,2", "262,5,1,2,2,2", "262,5,1,2,2,2", "261,5,1,2,2,2", "261,5,1,2,2,2", "261,5,1,2,2,2", "261,5,1,2,2,2", "261,5,1,2,2,2", "261,5,1,2,2,2", "261,5,1,2,2,2", "261,5,1,2,2,2", "260,5,1,2,2,2", "260,5,1,2,2,2", "259,5,1,2,2,2", "259,5,1,2,2,2", "261,5,1,2,2,2", "261,5,1,2,2,2", "261,5,1,2,2,2", "260,5,1,2,2,2", "259,5,1,2,2,2", "259,5,1,2,2,2", "258,5,1,2,2,2", "258,5,1,2,2,2", "256,5,1,2,2,2", "256,5,1,2,2,2", "254,5,1,2,2,2", "254,5,1,2,2,2", "253,5,1,2,2,2", "253,5,1,2,2,2", "257,5,1,2,2,2", "260,5,1,2,2,2", "262,5,1,2,2,2", "262,5,1,2,2,2", "262,5,1,2,2,2", "262,5,1,2,2,2", "262,5,1,2,2,2", "262,5,1,2,2,2", "262,5,1,2,2,2", "262,5,1,2,2,2", "263,5,1,2,2,2", "263,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "264,5,1,2,2,2", "259,5,1,2,2,2", "259,5,1,2,2,2", "256,5,1,2,2,2", "256,5,1,2,2,2", "248,5,1,2,2,2", "248,5,1,2,2,2", "241,5,1,2,2,2", "241,5,1,2,2,2", "232,5,1,2,2,2", "232,5,1,2,2,2", "222,5,1,2,2,2", "222,5,1,2,2,2", "212,5,1,2,2,2", "212,5,1,2,2,2", "201,5,1,2,2,2", "189,5,1,2,2,2", "189,5,1,2,2,2", "177,5,1,2,2,2", "177,5,1,2,2,2", "164,5,1,2,2,2", "150,5,1,2,2,2", "150,5,1,2,2,2", "124,5,1,2,2,2", "110,5,1,2,2,2", "110,5,1,2,2,2", "95,5,1,2,2,2", "95,5,1,2,2,2", "82,5,1,2,2,2", "82,5,1,2,2,2", "69,5,1,2,2,2", "69,5,1,2,2,2", "56,5,1,2,2,2", "43,5,1,2,2,2", "43,5,1,2,2,2", "31,5,1,2,2,2", "31,5,1,2,2,2", "19,5,1,2,2,2", "19,5,1,2,2,2", "10,5,1,2,2,2", "10,5,1,2,2,2", "15,5,1,2,2,2", "15,5,1,2,2,2", "26,5,1,2,2,2", "38,5,1,2,2,2", "38,5,1,2,2,2", "50,5,1,2,2,2", "50,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0"}, {"477,1,1,4,4,0", "472,1,1,4,4,0", "472,1,1,4,4,0", "461,5,1,4,4,2", "461,5,1,4,4,2", "458,5,1,4,4,2", "458,5,1,4,4,2", "455,5,1,4,4,2", "455,5,1,4,4,2", "452,5,1,4,4,2", "449,5,1,5,5,2", "449,5,1,5,5,2", "447,5,1,5,5,2", "447,5,1,5,5,2", "446,5,1,5,5,2", "446,5,1,5,5,2", "441,5,1,5,5,2", "441,5,1,5,5,2", "440,5,1,5,5,2", "440,5,1,5,5,2", "438,5,1,5,5,2", "438,5,1,5,5,2", "438,5,1,1,1,2", "435,5,1,1,1,2", "435,5,1,1,1,2", "434,5,1,1,1,2", "434,5,1,1,1,2", "433,5,1,1,1,2", "433,5,1,1,1,2", "432,5,1,1,1,2", "432,5,1,1,1,2", "433,5,1,1,1,2", "433,5,1,1,1,2", "433,5,1,1,1,2", "433,5,1,1,1,2", "432,5,1,1,1,2", "431,5,1,1,1,2", "431,5,1,1,1,2", "431,5,1,2,2,2", "431,5,1,2,2,2", "431,5,1,2,2,2", "431,5,1,2,2,2", "431,5,1,2,2,2", "431,5,1,2,2,2", "430,5,1,2,2,2", "430,5,1,2,2,2", "429,5,1,2,2,2", "429,5,1,2,2,2", "430,5,1,2,2,2", "430,5,1,2,2,2", "431,5,1,2,2,2", "430,5,1,2,2,2", "429,5,1,2,2,2", "429,5,1,2,2,2", "427,5,1,2,2,2", "427,5,1,2,2,2", "426,5,1,2,2,2", "426,5,1,2,2,2", "424,5,1,2,2,2", "424,5,1,2,2,2", "422,5,1,2,2,2", "422,5,1,2,2,2", "427,5,1,2,2,2", "429,5,1,2,2,2", "431,5,1,2,2,2", "431,5,1,2,2,2", "432,5,1,2,2,2", "432,5,1,2,2,2", "432,5,1,2,2,2", "432,5,1,2,2,2", "432,5,1,2,2,2", "432,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "433,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "434,5,1,2,2,2", "429,5,1,2,2,2", "429,5,1,2,2,2", "425,5,1,2,2,2", "425,5,1,2,2,2", "417,5,1,2,2,2", "417,5,1,2,2,2", "410,5,1,2,2,2", "410,5,1,2,2,2", "400,5,1,2,2,2", "400,5,1,2,2,2", "391,5,1,2,2,2", "391,5,1,2,2,2", "380,5,1,2,2,2", "380,5,1,2,2,2", "370,5,1,2,2,2", "358,5,1,2,2,2", "358,5,1,2,2,2", "346,5,1,2,2,2", "346,5,1,2,2,2", "332,5,1,2,2,2", "318,5,1,2,2,2", "318,5,1,2,2,2", "293,5,1,2,2,2", "278,5,1,2,2,2", "278,5,1,2,2,2", "263,5,1,2,2,2", "263,5,1,2,2,2", "250,5,1,2,2,2", "250,5,1,2,2,2", "237,5,1,2,2,2", "237,5,1,2,2,2", "224,5,1,2,2,2", "211,5,1,2,2,2", "211,5,1,2,2,2", "198,5,1,2,2,2", "198,5,1,2,2,2", "185,5,1,2,2,2", "185,5,1,2,2,2", "172,5,1,2,2,2", "172,5,1,2,2,2", "159,5,1,2,2,2", "159,5,1,2,2,2", "146,5,1,2,2,2", "134,5,1,2,2,2", "134,5,1,2,2,2", "121,5,1,2,2,2", "121,5,1,2,2,2", "93,5,1,2,2,2", "93,5,1,2,2,2", "65,5,1,2,2,2", "65,5,1,2,2,2", "48,5,1,2,2,2", "33,5,1,2,2,2", "19,5,1,2,2,2", "19,5,1,2,2,2", "24,5,1,2,2,2", "24,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,5,5,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0"}, {"688,1,1,2,2,0", "683,1,1,2,2,0", "683,1,1,2,2,0", "673,5,1,3,3,2", "673,5,1,3,3,2", "671,5,1,3,3,2", "671,5,1,3,3,2", "669,5,1,3,3,2", "669,5,1,3,3,2", "667,5,1,3,3,2", "664,5,1,3,3,2", "664,5,1,3,3,2", "662,5,1,3,3,2", "662,5,1,3,3,2", "662,5,1,3,3,2", "662,5,1,3,3,2", "658,5,1,3,3,2", "658,5,1,3,3,2", "656,5,1,3,3,2", "656,5,1,3,3,2", "655,5,1,3,3,2", "655,5,1,3,3,2", "655,5,1,3,3,2", "653,5,1,3,3,2", "653,5,1,3,3,2", "652,5,1,3,3,2", "652,5,1,3,3,2", "651,5,1,3,3,2", "651,5,1,3,3,2", "649,5,1,3,3,2", "649,5,1,3,3,2", "650,5,1,3,3,2", "650,5,1,3,3,2", "650,5,1,3,3,2", "650,5,1,4,4,2", "649,5,1,4,4,2", "649,5,1,4,4,2", "649,5,1,4,4,2", "649,5,1,4,4,2", "649,5,1,4,4,2", "648,5,1,4,4,2", "648,5,1,4,4,2", "648,5,1,4,4,2", "648,5,1,4,4,2", "647,5,1,4,4,2", "647,5,1,4,4,2", "646,5,1,4,4,2", "646,5,1,4,4,2", "648,5,1,4,4,2", "648,5,1,4,4,2", "648,5,1,4,4,2", "647,5,1,4,4,2", "646,5,1,4,4,2", "646,5,1,4,4,2", "645,5,1,4,4,2", "645,5,1,4,4,2", "643,5,1,4,4,2", "643,5,1,4,4,2", "641,5,1,4,4,2", "641,5,1,4,4,2", "640,5,1,4,4,2", "640,5,1,4,4,2", "644,5,1,4,4,2", "646,5,1,4,4,2", "649,5,1,4,4,2", "649,5,1,4,4,2", "649,5,1,4,4,2", "649,5,1,4,4,2", "649,5,1,1,1,2", "649,5,1,1,1,2", "649,5,1,1,1,2", "649,5,1,1,1,2", "650,5,1,1,1,2", "650,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "651,5,1,1,1,2", "646,5,1,1,1,2", "646,5,1,1,1,2", "642,5,1,2,2,2", "642,5,1,2,2,2", "634,5,1,2,2,2", "634,5,1,2,2,2", "627,5,1,2,2,2", "627,5,1,2,2,2", "617,5,1,2,2,2", "617,5,1,2,2,2", "607,5,1,2,2,2", "607,5,1,2,2,2", "597,5,1,2,2,2", "597,5,1,2,2,2", "587,5,1,2,2,2", "575,5,1,2,2,2", "575,5,1,2,2,2", "563,5,1,2,2,2", "563,5,1,2,2,2", "549,5,1,2,2,2", "535,5,1,2,2,2", "535,5,1,2,2,2", "510,5,1,2,2,2", "495,5,1,2,2,2", "495,5,1,2,2,2", "480,5,1,2,2,2", "480,5,1,2,2,2", "467,5,1,2,2,2", "467,5,1,2,2,2", "454,5,1,2,2,2", "454,5,1,2,2,2", "441,5,1,2,2,2", "428,5,1,2,2,2", "428,5,1,2,2,2", "415,5,1,2,2,2", "415,5,1,2,2,2", "402,5,1,2,2,2", "402,5,1,2,2,2", "390,5,1,2,2,2", "390,5,1,2,2,2", "377,5,1,2,2,2", "377,5,1,2,2,2", "364,5,1,2,2,2", "351,5,1,2,2,2", "351,5,1,2,2,2", "338,5,1,2,2,2", "338,5,1,2,2,2", "310,5,1,2,2,2", "310,5,1,2,2,2", "282,5,1,2,2,2", "282,5,1,2,2,2", "265,5,1,2,2,2", "249,5,1,2,2,2", "232,5,1,2,2,2", "232,5,1,2,2,2", "198,5,1,2,2,2", "198,5,1,2,2,2", "143,5,1,2,2,2", "143,5,1,2,2,2", "52,5,1,2,2,2", "26,5,1,2,2,2", "14,5,1,2,2,2", "4,5,1,2,2,2", "4,5,1,2,2,2", "12,5,1,2,2,2", "12,5,1,2,2,2", "26,5,1,2,2,2", "37,5,1,2,2,2", "50,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,1,1,2,2,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0"}, {"1041,1,1,2,2,0", "1036,1,1,2,2,0", "1036,1,1,2,2,0", "1028,1,1,2,2,0", "1028,5,1,2,2,2", "1027,5,1,2,2,2", "1027,5,1,2,2,2", "1025,5,1,2,2,2", "1025,5,1,2,2,2", "1024,5,1,2,2,2", "1022,5,1,2,2,2", "1022,5,1,2,2,2", "1021,5,1,2,2,2", "1021,5,1,2,2,2", "1021,5,1,2,2,2", "1021,5,1,2,2,2", "1019,5,1,2,2,2", "1019,5,1,2,2,2", "1018,5,1,2,2,2", "1018,5,1,2,2,2", "1017,5,1,2,2,2", "1017,5,1,2,2,2", "1017,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1014,5,1,2,2,2", "1014,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1014,5,1,2,2,2", "1014,5,1,2,2,2", "1014,5,1,2,2,2", "1014,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1012,5,1,2,2,2", "1012,5,1,2,2,2", "1012,5,1,2,2,2", "1012,5,1,2,2,2", "1011,5,1,2,2,2", "1011,5,1,2,2,2", "1010,5,1,2,2,2", "1010,5,1,2,2,2", "1012,5,1,2,2,2", "1012,5,1,2,2,2", "1012,5,1,2,2,2", "1011,5,1,2,2,2", "1010,5,1,2,2,2", "1010,5,1,2,2,2", "1009,5,1,2,2,2", "1009,5,1,2,2,2", "1007,5,1,2,2,2", "1007,5,1,2,2,2", "1005,5,1,2,2,2", "1005,5,1,2,2,2", "1004,5,1,2,2,2", "1004,5,1,2,2,2", "1008,5,1,2,2,2", "1010,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1013,5,1,2,2,2", "1014,5,1,2,2,2", "1014,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1015,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1016,5,1,2,2,2", "1010,5,1,2,2,2", "1010,5,1,2,2,2", "1006,5,1,2,2,2", "1006,5,1,2,2,2", "998,5,1,2,2,2", "998,5,1,2,2,2", "991,5,1,2,2,2", "991,5,1,2,2,2", "981,5,1,2,2,2", "981,5,1,2,2,2", "972,5,1,2,2,2", "972,5,1,2,2,2", "961,5,1,2,2,2", "961,5,1,2,2,2", "951,5,1,2,2,2", "939,5,1,2,2,2", "939,5,1,2,2,2", "927,5,1,2,2,2", "927,5,1,2,2,2", "913,5,1,2,2,2", "899,5,1,2,2,2", "899,5,1,2,2,2", "874,5,1,2,2,2", "859,5,1,2,2,2", "859,5,1,2,2,2", "845,5,1,2,2,2", "845,5,1,2,2,2", "832,5,1,2,2,2", "832,5,1,2,2,2", "818,5,1,2,2,2", "818,5,1,2,2,2", "805,5,1,2,2,2", "792,5,1,2,2,2", "792,5,1,2,2,2", "779,5,1,2,2,2", "779,5,1,2,2,2", "766,5,1,2,2,2", "766,5,1,2,2,2", "754,5,1,2,2,2", "754,5,1,2,2,2", "741,5,1,2,2,2", "741,5,1,2,2,2", "728,5,1,2,2,2", "715,5,1,2,2,2", "715,5,1,2,2,2", "702,5,1,2,2,2", "702,5,1,2,2,2", "675,5,1,2,2,2", "675,5,1,2,2,2", "646,5,1,2,2,2", "646,5,1,2,2,2", "629,5,1,2,2,2", "613,5,1,2,2,2", "597,5,1,2,2,2", "597,5,1,2,2,2", "562,5,1,2,2,2", "562,5,1,2,2,2", "508,5,1,2,2,2", "508,5,1,2,2,2", "416,5,1,2,2,2", "390,5,1,2,2,2", "377,5,1,2,2,2", "363,5,1,2,2,2", "363,5,1,2,2,2", "352,5,1,2,2,2", "352,5,1,2,2,2", "339,5,1,2,2,2", "327,5,1,2,2,2", "314,5,1,2,2,2", "300,5,1,2,2,2", "287,5,1,2,2,2", "273,5,1,2,2,2", "273,5,1,2,2,2", "259,5,1,2,2,2", "259,5,1,2,2,2", "247,5,1,2,2,2", "235,5,1,2,2,2", "229,5,1,2,2,2", "229,5,1,2,2,2", "221,5,1,2,2,2", "221,5,1,2,2,2", "209,5,1,2,2,2", "209,5,1,2,2,2", "191,5,1,2,2,2", "179,5,1,2,2,2", "167,5,1,2,2,2", "159,5,1,2,2,2", "148,5,1,2,2,2", "148,5,1,2,2,2", "129,5,1,2,2,2", "121,5,1,2,2,2", "121,5,1,2,2,2", "111,5,1,2,2,2", "103,5,1,2,2,2", "103,5,1,2,2,2", "93,5,1,2,2,2", "93,5,1,2,2,2", "70,5,1,2,2,2", "45,5,1,2,2,2", "33,5,1,2,2,2", "13,5,1,2,2,2", "9,5,1,2,2,2", "9,5,1,2,2,2", "29,5,1,2,2,2", "41,5,1,2,2,2", "41,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0"}, {"1189,1,1,2,2,0", "1184,1,1,2,2,0", "1184,1,1,2,2,0", "1176,1,1,2,2,0", "1176,5,1,2,2,2", "1176,5,1,2,2,2", "1176,5,1,2,2,2", "1174,5,1,2,2,2", "1174,5,1,2,2,2", "1173,5,1,2,2,2", "1171,5,1,2,2,2", "1171,5,1,2,2,2", "1170,5,1,2,2,2", "1170,5,1,2,2,2", "1171,5,1,2,2,2", "1171,5,1,2,2,2", "1168,5,1,2,2,2", "1168,5,1,2,2,2", "1167,5,1,2,2,2", "1167,5,1,2,2,2", "1167,5,1,2,2,2", "1167,5,1,2,2,2", "1167,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1164,5,1,2,2,2", "1164,5,1,2,2,2", "1163,5,1,2,2,2", "1163,5,1,2,2,2", "1164,5,1,2,2,2", "1164,5,1,2,2,2", "1164,5,1,2,2,2", "1164,5,1,2,2,2", "1163,5,1,2,2,2", "1163,5,1,2,2,2", "1163,5,1,2,2,2", "1163,5,1,2,2,2", "1163,5,1,2,2,2", "1162,5,1,2,2,2", "1162,5,1,2,2,2", "1162,5,1,2,2,2", "1162,5,1,2,2,2", "1161,5,1,2,2,2", "1161,5,1,2,2,2", "1161,5,1,2,2,2", "1161,5,1,2,2,2", "1162,5,1,2,2,2", "1162,5,1,2,2,2", "1163,5,1,2,2,2", "1161,5,1,2,2,2", "1160,5,1,2,2,2", "1160,5,1,2,2,2", "1159,5,1,2,2,2", "1159,5,1,2,2,2", "1157,5,1,2,2,2", "1157,5,1,2,2,2", "1155,5,1,2,2,2", "1155,5,1,2,2,2", "1154,5,1,2,2,2", "1154,5,1,2,2,2", "1158,5,1,2,2,2", "1161,5,1,2,2,2", "1163,5,1,2,2,2", "1163,5,1,2,2,2", "1164,5,1,2,2,2", "1164,5,1,2,2,2", "1163,5,1,2,2,2", "1163,5,1,2,2,2", "1163,5,1,2,2,2", "1163,5,1,2,2,2", "1164,5,1,2,2,2", "1164,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1165,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1166,5,1,2,2,2", "1160,5,1,2,2,2", "1160,5,1,2,2,2", "1156,5,1,2,2,2", "1156,5,1,2,2,2", "1148,5,1,2,2,2", "1148,5,1,2,2,2", "1141,5,1,2,2,2", "1141,5,1,2,2,2", "1131,5,1,2,2,2", "1131,5,1,2,2,2", "1122,5,1,2,2,2", "1122,5,1,2,2,2", "1112,5,1,2,2,2", "1112,5,1,2,2,2", "1101,5,1,2,2,2", "1089,5,1,2,2,2", "1089,5,1,2,2,2", "1077,5,1,2,2,2", "1077,5,1,2,2,2", "1064,5,1,2,2,2", "1049,5,1,2,2,2", "1049,5,1,2,2,2", "1024,5,1,2,2,2", "1009,5,1,2,2,2", "1009,5,1,2,2,2", "995,5,1,2,2,2", "995,5,1,2,2,2", "982,5,1,2,2,2", "982,5,1,2,2,2", "968,5,1,2,2,2", "968,5,1,2,2,2", "955,5,1,2,2,2", "942,5,1,2,2,2", "942,5,1,2,2,2", "929,5,1,2,2,2", "929,5,1,2,2,2", "916,5,1,2,2,2", "916,5,1,2,2,2", "904,5,1,2,2,2", "904,5,1,2,2,2", "891,5,1,2,2,2", "891,5,1,2,2,2", "878,5,1,2,2,2", "865,5,1,2,2,2", "865,5,1,2,2,2", "852,5,1,2,2,2", "852,5,1,2,2,2", "825,5,1,2,2,2", "825,5,1,2,2,2", "796,5,1,2,2,2", "796,5,1,2,2,2", "779,5,1,2,2,2", "763,5,1,2,2,2", "747,5,1,2,2,2", "747,5,1,2,2,2", "712,5,1,2,2,2", "712,5,1,2,2,2", "658,5,1,2,2,2", "658,5,1,2,2,2", "566,5,1,2,2,2", "540,5,1,2,2,2", "527,5,1,2,2,2", "513,5,1,2,2,2", "513,5,1,2,2,2", "502,5,1,2,2,2", "502,5,1,2,2,2", "489,5,1,2,2,2", "477,5,1,2,2,2", "464,5,1,2,2,2", "450,5,1,2,2,2", "437,5,1,2,2,2", "423,5,1,2,2,2", "423,5,1,2,2,2", "409,5,1,2,2,2", "409,5,1,2,2,2", "397,5,1,2,2,2", "385,5,1,2,2,2", "379,5,1,2,2,2", "379,5,1,2,2,2", "371,5,1,2,2,2", "371,5,1,2,2,2", "359,5,1,2,2,2", "359,5,1,2,2,2", "341,5,1,2,2,2", "329,5,1,2,2,2", "317,5,1,2,2,2", "309,5,1,2,2,2", "298,5,1,2,2,2", "298,5,1,2,2,2", "279,5,1,2,2,2", "271,5,1,2,2,2", "271,5,1,2,2,2", "260,5,1,2,2,2", "252,5,1,2,2,2", "252,5,1,2,2,2", "242,5,1,2,2,2", "242,5,1,2,2,2", "219,5,1,2,2,2", "194,5,1,2,2,2", "181,5,1,2,2,2", "159,5,1,2,2,2", "147,5,1,2,2,2", "147,5,1,2,2,2", "122,5,1,2,2,2", "109,5,1,2,2,2", "109,5,1,2,2,2", "84,5,1,2,2,2", "70,5,1,2,2,2", "70,5,1,2,2,2", "57,5,1,2,2,2", "41,5,1,2,2,2", "24,5,1,2,2,2", "8,5,1,2,2,2", "8,5,1,2,2,2", "25,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,1,1,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0"}, {"1403,1,1,2,2,0", "1398,1,1,2,2,0", "1398,1,1,2,2,0", "1390,1,1,2,2,0", "1390,1,1,2,2,0", "1390,1,1,2,2,0", "1390,1,1,2,2,0", "1388,5,1,2,2,2", "1388,5,1,2,2,2", "1388,5,1,2,2,2", "1386,5,1,2,2,2", "1386,5,1,2,2,2", "1385,5,1,2,2,2", "1385,5,1,2,2,2", "1386,5,1,2,2,2", "1386,5,1,2,2,2", "1384,5,1,2,2,2", "1384,5,1,2,2,2", "1383,5,1,2,2,2", "1383,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1383,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1380,5,1,2,2,2", "1380,5,1,2,2,2", "1379,5,1,2,2,2", "1379,5,1,2,2,2", "1380,5,1,2,2,2", "1380,5,1,2,2,2", "1380,5,1,2,2,2", "1380,5,1,2,2,2", "1380,5,1,2,2,2", "1379,5,1,2,2,2", "1379,5,1,2,2,2", "1379,5,1,2,2,2", "1379,5,1,2,2,2", "1379,5,1,2,2,2", "1379,5,1,2,2,2", "1379,5,1,2,2,2", "1379,5,1,2,2,2", "1378,5,1,2,2,2", "1378,5,1,2,2,2", "1377,5,1,2,2,2", "1377,5,1,2,2,2", "1378,5,1,2,2,2", "1378,5,1,2,2,2", "1379,5,1,2,2,2", "1378,5,1,2,2,2", "1377,5,1,2,2,2", "1377,5,1,2,2,2", "1375,5,1,2,2,2", "1375,5,1,2,2,2", "1374,5,1,2,2,2", "1374,5,1,2,2,2", "1372,5,1,2,2,2", "1372,5,1,2,2,2", "1370,5,1,2,2,2", "1370,5,1,2,2,2", "1375,5,1,2,2,2", "1377,5,1,2,2,2", "1379,5,1,2,2,2", "1379,5,1,2,2,2", "1380,5,1,2,2,2", "1380,5,1,2,2,2", "1380,5,1,2,2,2", "1380,5,1,2,2,2", "1379,5,1,2,2,2", "1379,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1381,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1382,5,1,2,2,2", "1377,5,1,2,2,2", "1377,5,1,2,2,2", "1373,5,1,2,2,2", "1373,5,1,2,2,2", "1365,5,1,2,2,2", "1365,5,1,2,2,2", "1358,5,1,2,2,2", "1358,5,1,2,2,2", "1348,5,1,2,2,2", "1348,5,1,2,2,2", "1338,5,1,2,2,2", "1338,5,1,2,2,2", "1328,5,1,2,2,2", "1328,5,1,2,2,2", "1318,5,1,2,2,2", "1306,5,1,2,2,2", "1306,5,1,2,2,2", "1294,5,1,2,2,2", "1294,5,1,2,2,2", "1280,5,1,2,2,2", "1266,5,1,2,2,2", "1266,5,1,2,2,2", "1241,5,1,2,2,2", "1226,5,1,2,2,2", "1226,5,1,2,2,2", "1211,5,1,2,2,2", "1211,5,1,2,2,2", "1198,5,1,2,2,2", "1198,5,1,2,2,2", "1185,5,1,2,2,2", "1185,5,1,2,2,2", "1172,5,1,2,2,2", "1159,5,1,2,2,2", "1159,5,1,2,2,2", "1146,5,1,2,2,2", "1146,5,1,2,2,2", "1133,5,1,2,2,2", "1133,5,1,2,2,2", "1120,5,1,2,2,2", "1120,5,1,2,2,2", "1107,5,1,2,2,2", "1107,5,1,2,2,2", "1094,5,1,2,2,2", "1082,5,1,2,2,2", "1082,5,1,2,2,2", "1069,5,1,2,2,2", "1069,5,1,2,2,2", "1041,5,1,2,2,2", "1041,5,1,2,2,2", "1012,5,1,2,2,2", "1012,5,1,2,2,2", "996,5,1,2,2,2", "980,5,1,2,2,2", "963,5,1,2,2,2", "963,5,1,2,2,2", "929,5,1,2,2,2", "929,5,1,2,2,2", "875,5,1,2,2,2", "875,5,1,2,2,2", "783,5,1,2,2,2", "756,5,1,2,2,2", "743,5,1,2,2,2", "730,5,1,2,2,2", "730,5,1,2,2,2", "719,5,1,2,2,2", "719,5,1,2,2,2", "706,5,1,2,2,2", "694,5,1,2,2,2", "680,5,1,2,2,2", "667,5,1,2,2,2", "653,5,1,2,2,2", "640,5,1,2,2,2", "640,5,1,2,2,2", "626,5,1,2,2,2", "626,5,1,2,2,2", "614,5,1,2,2,2", "602,5,1,2,2,2", "595,5,1,2,2,2", "595,5,1,2,2,2", "587,5,1,2,2,2", "587,5,1,2,2,2", "576,5,1,2,2,2", "576,5,1,2,2,2", "557,5,1,2,2,2", "546,5,1,2,2,2", "534,5,1,2,2,2", "526,5,1,2,2,2", "515,5,1,2,2,2", "515,5,1,2,2,2", "496,5,1,2,2,2", "487,5,1,2,2,2", "487,5,1,2,2,2", "477,5,1,2,2,2", "468,5,1,2,2,2", "468,5,1,2,2,2", "459,5,1,2,2,2", "459,5,1,2,2,2", "435,5,1,2,2,2", "410,5,1,2,2,2", "398,5,1,2,2,2", "376,5,1,2,2,2", "363,5,1,2,2,2", "363,5,1,2,2,2", "339,5,1,2,2,2", "326,5,1,2,2,2", "326,5,1,2,2,2", "300,5,1,2,2,2", "286,5,1,2,2,2", "286,5,1,2,2,2", "273,5,1,2,2,2", "258,5,1,2,2,2", "241,5,1,2,2,2", "224,5,1,2,2,2", "208,5,1,2,2,2", "191,5,1,2,2,2", "131,5,1,2,2,2", "105,5,1,2,2,2", "91,5,1,2,2,2", "77,5,1,2,2,2", "66,5,1,2,2,2", "28,5,1,2,2,2", "17,5,1,2,2,2", "8,5,1,2,2,2", "6,5,1,2,2,2", "14,5,1,2,2,2", "22,5,1,2,2,2", "35,5,1,2,2,2", "48,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,5,1,2,2,2", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,2,2,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0", "0,1,1,3,3,0"}, {"1684,1,1,3,3,0", "1680,1,1,3,3,0", "1680,1,1,3,3,0", "1672,1,1,3,3,0", "1672,1,1,3,3,0", "1672,5,1,3,3,4", "1672,5,1,3,3,4", "1671,5,1,3,3,4", "1671,5,1,3,3,4", "1671,5,1,3,3,4", "1669,5,1,4,4,4", "1669,5,1,4,4,4", "1669,5,1,4,4,4", "1669,5,1,4,4,4", "1669,5,1,4,4,4", "1669,5,1,4,4,4", "1668,5,1,4,4,4", "1668,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1667,5,1,4,4,4", "1665,5,1,4,4,4", "1665,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1665,5,1,4,4,4", "1665,5,1,4,4,4", "1664,5,1,4,4,4", "1664,5,1,4,4,4", "1665,5,1,4,4,4", "1665,5,1,4,4,4", "1665,5,1,4,4,4", "1665,5,1,4,4,4", "1664,5,1,4,4,4", "1664,5,1,4,4,4", "1664,5,1,4,4,4", "1664,5,1,4,4,4", "1664,5,1,4,4,4", "1664,5,1,4,4,4", "1664,5,1,4,4,4", "1663,5,1,4,4,4", "1663,5,1,4,4,4", "1662,5,1,4,4,4", "1662,5,1,4,4,4", "1662,5,1,4,4,4", "1662,5,1,4,4,4", "1663,5,1,4,4,4", "1663,5,1,4,4,4", "1664,5,1,4,4,4", "1662,5,1,4,4,4", "1661,5,1,4,4,4", "1661,5,1,4,4,4", "1660,5,1,4,4,4", "1660,5,1,4,4,4", "1659,5,1,4,4,4", "1659,5,1,4,4,4", "1657,5,1,4,4,4", "1657,5,1,4,4,4", "1655,5,1,4,4,4", "1655,5,1,4,4,4", "1659,5,1,4,4,4", "1662,5,1,4,4,4", "1664,5,1,4,4,4", "1664,5,1,4,4,4", "1665,5,1,4,4,4", "1665,5,1,4,4,4", "1664,5,1,4,4,4", "1664,5,1,4,4,4", "1664,5,1,4,4,4", "1664,5,1,4,4,4", "1665,5,1,4,4,4", "1665,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1666,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1667,5,1,4,4,4", "1662,5,1,4,4,4", "1662,5,1,4,4,4", "1658,5,1,4,4,4", "1658,5,1,4,4,4", "1650,5,1,4,4,4", "1650,5,1,4,4,4", "1643,5,1,4,4,4", "1643,5,1,4,4,4", "1633,5,1,4,4,4", "1633,5,1,4,4,4", "1623,5,1,4,4,4", "1623,5,1,4,4,4", "1613,5,1,4,4,4", "1613,5,1,4,4,4", "1602,5,1,4,4,4", "1591,5,1,4,4,4", "1591,5,1,4,4,4", "1579,5,1,4,4,4", "1579,5,1,4,4,4", "1565,5,1,4,4,4", "1551,5,1,4,4,4", "1551,5,1,4,4,4", "1525,5,1,4,4,4", "1511,5,1,4,4,4", "1511,5,1,4,4,4", "1496,5,1,4,4,4", "1496,5,1,4,4,4", "1483,5,1,4,4,4", "1483,5,1,4,4,4", "1470,5,1,4,4,4", "1470,5,1,4,4,4", "1457,5,1,4,4,4", "1444,5,1,4,4,4", "1444,5,1,4,4,4", "1431,5,1,4,4,4", "1431,5,1,4,4,4", "1418,5,1,4,4,4", "1418,5,1,4,4,4", "1405,5,1,4,4,4", "1405,5,1,4,4,4", "1392,5,1,4,4,4", "1392,5,1,4,4,4", "1379,5,1,4,4,4", "1366,5,1,4,4,4", "1366,5,1,4,4,4", "1353,5,1,4,4,4", "1353,5,1,4,4,4", "1326,5,1,4,4,4", "1326,5,1,4,4,4", "1297,5,1,4,4,4", "1297,5,1,4,4,4", "1281,5,1,4,4,4", "1265,5,1,4,4,4", "1248,5,1,4,4,4", "1248,5,1,4,4,4", "1214,5,1,4,4,4", "1214,5,1,4,4,4", "1160,5,1,4,4,4", "1160,5,1,4,4,4", "1068,5,1,4,4,4", "1041,5,1,4,4,4", "1028,5,1,4,4,4", "1014,5,1,4,4,4", "1014,5,1,4,4,4", "1004,5,1,4,4,4", "1004,5,1,4,4,4", "991,5,1,4,4,4", "979,5,1,4,4,4", "965,5,1,4,4,4", "952,5,1,4,4,4", "938,5,1,4,4,4", "925,5,1,4,4,4", "925,5,1,4,4,4", "911,5,1,4,4,4", "911,5,1,4,4,4", "898,5,1,4,4,4", "886,5,1,4,4,4", "880,5,1,4,4,4", "880,5,1,4,4,4", "872,5,1,4,4,4", "872,5,1,4,4,4", "861,5,1,4,4,4", "861,5,1,4,4,4", "842,5,1,4,4,4", "831,5,1,4,4,4", "819,5,1,4,4,4", "811,5,1,4,4,4", "800,5,1,4,4,4", "800,5,1,4,4,4", "781,5,1,4,4,4", "772,5,1,4,4,4", "772,5,1,4,4,4", "762,5,1,4,4,4", "753,5,1,4,4,4", "753,5,1,4,4,4", "743,5,1,4,4,4", "743,5,1,4,4,4", "720,5,1,4,4,4", "695,5,1,4,4,4", "683,5,1,4,4,4", "661,5,1,4,4,4", "648,5,1,4,4,4", "648,5,1,4,4,4", "624,5,1,4,4,4", "611,5,1,4,4,4", "611,5,1,4,4,4", "585,5,1,4,4,4", "571,5,1,4,4,4", "571,5,1,4,4,4", "558,5,1,4,4,4", "543,5,1,4,4,4", "526,5,1,4,4,4", "509,5,1,4,4,4", "493,5,1,4,4,4", "476,5,1,4,4,4", "416,5,1,4,4,4", "390,5,1,4,4,4", "376,5,1,4,4,4", "362,5,1,4,4,4", "351,5,1,4,4,4", "313,5,1,4,4,4", "301,5,1,4,4,4", "291,5,1,4,4,4", "283,5,1,4,4,4", "273,5,1,4,4,4", "264,5,1,4,4,4", "250,5,1,4,4,4", "238,5,1,4,4,4", "217,5,1,4,4,4", "203,5,1,4,4,4", "193,5,1,4,4,4", "182,5,1,4,4,4", "172,5,1,4,4,4", "160,5,1,4,4,4", "149,5,1,4,4,4", "138,5,1,4,4,4", "127,5,1,4,4,4", "112,5,1,4,4,4", "100,5,1,4,4,4", "88,5,1,4,4,4", "75,5,1,4,4,4", "75,5,1,4,4,4", "50,5,1,4,4,4", "38,5,1,4,4,4", "22,5,1,4,4,4", "8,5,1,4,4,4", "7,5,1,4,4,4", "13,5,1,4,4,4", "17,5,1,4,4,4", "17,5,1,4,4,4", "21,5,1,4,4,4", "34,5,1,4,4,4", "43,5,1,4,4,4", "64,5,1,4,4,4", "0,5,1,4,4,4", "0,5,1,4,4,4", "0,5,1,4,4,4", "0,5,1,4,4,4", "0,5,1,4,4,4", "0,5,1,4,4,4", "0,5,1,4,4,4", "0,5,1,4,4,4", "0,5,1,4,4,4", "0,5,1,4,4,4", "0,1,1,4,4,4", "0,1,1,4,4,4", "0,1,1,4,4,0", "0,1,1,4,4,0", "0,1,1,4,4,0"}};
        long[] nodeIdArr = new long[]{1382L, 96L, 97L, 735L, 238L, 98L, 667L, 510L, 439L};
        String clctDt = EvpsUtils.getClctDt();
        this.listSignalDto = new ArrayList();
        for (int jj = 0; jj < signalArr[0].length; ++jj) {
            KafkaEvpsSignalDto data = KafkaEvpsSignalDto.builder().serviceId(this.serviceId).clctDt(clctDt).signalList(new ArrayList()).build();
            for (int ii = 0; ii < nodeIdArr.length; ++ii) {
                int seqNo = ii + 1;
                long nodeId = nodeIdArr[ii];
                List value = StringUtils.split((String)signalArr[ii][jj], (String)",");
                assert (value.size() != 5);
                int remDist = Integer.parseInt((String)value.get(0));
                int state = Integer.parseInt((String)value.get(1));
                int planClass = Integer.parseInt((String)value.get(2));
                int aRingPhase = Integer.parseInt((String)value.get(3));
                int bRingPhase = Integer.parseInt((String)value.get(4));
                int holdPhase = Integer.parseInt((String)value.get(5));
                EvpsSignalInfo signal = EvpsSignalInfo.builder().serviceId(this.serviceId).clctDt(clctDt).nodeId(Long.valueOf(nodeId)).seqNo(Integer.valueOf(seqNo)).remDist(Integer.valueOf(remDist)).state(Integer.valueOf(state)).planClass(Integer.valueOf(planClass)).aRingPhase(Integer.valueOf(aRingPhase)).bRingPhase(Integer.valueOf(bRingPhase)).holdPhase(Integer.valueOf(holdPhase)).build();
                data.getSignalList().add(signal);
            }
            this.listSignalDto.add(data);
        }
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getVehNo() {
        return this.vehNo;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public int getServiceEndReason() {
        return this.serviceEndReason;
    }

    public KafkaEvpsServiceDto getServiceStartDto() {
        return this.serviceStartDto;
    }

    public KafkaEvpsServiceEndDto getServiceEndDto() {
        return this.serviceEndDto;
    }

    public KafkaEvpsNodeDto getEvpsNodeDto() {
        return this.evpsNodeDto;
    }

    public List<KafkaEvpsEventDto> getListEventDto() {
        return this.listEventDto;
    }

    public List<KafkaEvpsSignalDto> getListSignalDto() {
        return this.listSignalDto;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setVehNo(String vehNo) {
        this.vehNo = vehNo;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setServiceEndReason(int serviceEndReason) {
        this.serviceEndReason = serviceEndReason;
    }

    public void setServiceStartDto(KafkaEvpsServiceDto serviceStartDto) {
        this.serviceStartDto = serviceStartDto;
    }

    public void setServiceEndDto(KafkaEvpsServiceEndDto serviceEndDto) {
        this.serviceEndDto = serviceEndDto;
    }

    public void setEvpsNodeDto(KafkaEvpsNodeDto evpsNodeDto) {
        this.evpsNodeDto = evpsNodeDto;
    }

    public void setListEventDto(List<KafkaEvpsEventDto> listEventDto) {
        this.listEventDto = listEventDto;
    }

    public void setListSignalDto(List<KafkaEvpsSignalDto> listSignalDto) {
        this.listSignalDto = listSignalDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvpsKafkaSimGen)) {
            return false;
        }
        EvpsKafkaSimGen other = (EvpsKafkaSimGen)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getServiceEndReason() != other.getServiceEndReason()) {
            return false;
        }
        String this$regionId = this.getRegionId();
        String other$regionId = other.getRegionId();
        if (this$regionId == null ? other$regionId != null : !this$regionId.equals(other$regionId)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        String this$vehNo = this.getVehNo();
        String other$vehNo = other.getVehNo();
        if (this$vehNo == null ? other$vehNo != null : !this$vehNo.equals(other$vehNo)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        KafkaEvpsServiceDto this$serviceStartDto = this.getServiceStartDto();
        KafkaEvpsServiceDto other$serviceStartDto = other.getServiceStartDto();
        if (this$serviceStartDto == null ? other$serviceStartDto != null : !this$serviceStartDto.equals(other$serviceStartDto)) {
            return false;
        }
        KafkaEvpsServiceEndDto this$serviceEndDto = this.getServiceEndDto();
        KafkaEvpsServiceEndDto other$serviceEndDto = other.getServiceEndDto();
        if (this$serviceEndDto == null ? other$serviceEndDto != null : !this$serviceEndDto.equals(other$serviceEndDto)) {
            return false;
        }
        KafkaEvpsNodeDto this$evpsNodeDto = this.getEvpsNodeDto();
        KafkaEvpsNodeDto other$evpsNodeDto = other.getEvpsNodeDto();
        if (this$evpsNodeDto == null ? other$evpsNodeDto != null : !this$evpsNodeDto.equals(other$evpsNodeDto)) {
            return false;
        }
        List this$listEventDto = this.getListEventDto();
        List other$listEventDto = other.getListEventDto();
        if (this$listEventDto == null ? other$listEventDto != null : !((Object)this$listEventDto).equals(other$listEventDto)) {
            return false;
        }
        List this$listSignalDto = this.getListSignalDto();
        List other$listSignalDto = other.getListSignalDto();
        return !(this$listSignalDto == null ? other$listSignalDto != null : !((Object)this$listSignalDto).equals(other$listSignalDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EvpsKafkaSimGen;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getServiceEndReason();
        String $regionId = this.getRegionId();
        result = result * 59 + ($regionId == null ? 43 : $regionId.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        String $vehNo = this.getVehNo();
        result = result * 59 + ($vehNo == null ? 43 : $vehNo.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        KafkaEvpsServiceDto $serviceStartDto = this.getServiceStartDto();
        result = result * 59 + ($serviceStartDto == null ? 43 : $serviceStartDto.hashCode());
        KafkaEvpsServiceEndDto $serviceEndDto = this.getServiceEndDto();
        result = result * 59 + ($serviceEndDto == null ? 43 : $serviceEndDto.hashCode());
        KafkaEvpsNodeDto $evpsNodeDto = this.getEvpsNodeDto();
        result = result * 59 + ($evpsNodeDto == null ? 43 : $evpsNodeDto.hashCode());
        List $listEventDto = this.getListEventDto();
        result = result * 59 + ($listEventDto == null ? 43 : ((Object)$listEventDto).hashCode());
        List $listSignalDto = this.getListSignalDto();
        result = result * 59 + ($listSignalDto == null ? 43 : ((Object)$listSignalDto).hashCode());
        return result;
    }

    public String toString() {
        return "EvpsKafkaSimGen(regionId=" + this.getRegionId() + ", serviceName=" + this.getServiceName() + ", vehNo=" + this.getVehNo() + ", serviceId=" + this.getServiceId() + ", serviceEndReason=" + this.getServiceEndReason() + ", serviceStartDto=" + this.getServiceStartDto() + ", serviceEndDto=" + this.getServiceEndDto() + ", evpsNodeDto=" + this.getEvpsNodeDto() + ", listEventDto=" + this.getListEventDto() + ", listSignalDto=" + this.getListSignalDto() + ")";
    }
}

