/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.service;

import com.evps.comm.local.config.ApplicationConfig;
import com.evps.comm.local.dto.CenterDto;
import com.evps.comm.local.repository.ApplicationRepository;
import com.evps.comm.local.service.EvpsDataSimGen;
import com.evps.comm.local.xnet.client.process.request.EvpsEvent;
import com.evps.comm.local.xnet.client.process.request.EvpsFrameData;
import com.evps.comm.local.xnet.client.process.request.EvpsNetPing;
import com.evps.comm.local.xnet.client.process.request.EvpsNode;
import com.evps.comm.local.xnet.client.process.request.EvpsService;
import com.evps.comm.local.xnet.client.process.request.EvpsServiceEnd;
import com.evps.comm.local.xnet.client.process.request.EvpsSignal;
import com.evps.common.kafka.dto.KafkaEvpsEventDto;
import com.evps.common.kafka.dto.KafkaEvpsNodeDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceEndDto;
import com.evps.common.kafka.dto.KafkaEvpsSignalDto;
import com.evps.common.utils.EvpsUtils;
import com.its.common.utils.Elapsed;
import com.its.common.utils.TimeUtils;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EvpsLocalClientManagerService {
    private static final Logger log = LoggerFactory.getLogger(EvpsLocalClientManagerService.class);
    private final ApplicationConfig config;
    private boolean isRunning = false;

    @PostConstruct
    private void init() {
        this.isRunning = false;
    }

    public void sendPing() {
        if (this.isRunning) {
            log.info("Sending ping: Evps Data Sending....");
            return;
        }
        CenterDto center = ApplicationRepository.center;
        if (center.getNetState().getState() < 1 || center.getNetState().getChannel() == null) {
            log.info("Sending ping: Center communication failed.");
            return;
        }
        long currentTimeMilliSeconds = System.currentTimeMillis();
        if (currentTimeMilliSeconds - center.getLastCommTm() >= (long)this.config.getNetPingSeconds() * 1000L) {
            String now = TimeUtils.getCurrentTimeString();
            String serviceId = this.config.getRegionId() + now + "00";
            EvpsNetPing ping = new EvpsNetPing(serviceId, (long)center.getSeq().nextValue());
            center.sendData((EvpsFrameData)ping);
        } else {
            log.info("Sending ping: Last ping sent {} seconds ago. net ping duration {} seconds.", (Object)((currentTimeMilliSeconds - center.getLastCommTm()) / 1000L), (Object)this.config.getNetPingSeconds());
        }
    }

    public void run() {
        if (this.isRunning) {
            log.warn("EvpsLocalClientManagerService: Already running....................");
            return;
        }
        CenterDto center = ApplicationRepository.center;
        if (center.getNetState().getState() < 1 || center.getNetState().getChannel() == null) {
            log.info("EvpsLocalClientManagerService: Center communication failed.");
            return;
        }
        this.isRunning = true;
        Elapsed elapsed = new Elapsed();
        EvpsDataSimGen simGenData = new EvpsDataSimGen(this.config.getRegionId(), "\ub300\uc885\ub85c \uc0ac\uac70\ub9ac", "74\ubb345035", 2);
        simGenData.makeEvpsKafkaSimulatorData();
        KafkaEvpsServiceDto serviceDto = simGenData.getServiceStartDto();
        serviceDto.setClctDt(EvpsUtils.getClctDt());
        EvpsService service = new EvpsService(serviceDto);
        center.sendData((EvpsFrameData)service);
        KafkaEvpsNodeDto nodeDto = simGenData.getEvpsNodeDto();
        nodeDto.setClctDt(EvpsUtils.getClctDt());
        EvpsNode node = new EvpsNode(nodeDto);
        center.sendData((EvpsFrameData)node);
        for (int ii = 0; ii < simGenData.getListSignalDto().size(); ++ii) {
            TimeUtils.sleep((long)1000L);
            KafkaEvpsSignalDto signalDto = (KafkaEvpsSignalDto)simGenData.getListSignalDto().get(ii);
            signalDto.setClctDt(EvpsUtils.getClctDt());
            EvpsSignal signal = new EvpsSignal(signalDto);
            center.sendData((EvpsFrameData)signal);
            KafkaEvpsEventDto eventDto = (KafkaEvpsEventDto)simGenData.getListEventDto().get(ii);
            eventDto.setClctDt(EvpsUtils.getClctDt());
            EvpsEvent event = new EvpsEvent(eventDto);
            center.sendData((EvpsFrameData)event);
        }
        KafkaEvpsServiceEndDto endDto = simGenData.getServiceEndDto();
        endDto.setClctDt(EvpsUtils.getClctDt());
        EvpsServiceEnd serviceEnd = new EvpsServiceEnd(endDto);
        center.sendData((EvpsFrameData)serviceEnd);
        log.info("EvpsLocalClientManagerService: Run completed. {}", (Object)elapsed.elapsedTimeStr());
        this.isRunning = false;
    }

    public EvpsLocalClientManagerService(ApplicationConfig config) {
        this.config = config;
    }
}

