/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.xnet.client.process.request;

import com.evps.comm.local.xnet.client.process.request.EvpsFrameData;
import com.evps.common.kafka.dto.EvpsNodeInfo;
import com.evps.common.kafka.dto.EvpsPhaseInfo;
import com.evps.common.kafka.dto.KafkaEvpsNodeDto;
import com.evps.common.protocol.eEvpsOpCode;
import com.its.common.utils.ByteUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EvpsNode
extends EvpsFrameData {
    public EvpsNode(KafkaEvpsNodeDto node) {
        super(eEvpsOpCode.EVPS_NODE.getValue(), node.getServiceId());
        int ii;
        int bodySize = 2;
        int lcList = node.getNodeList().size();
        for (ii = 0; ii < lcList; ++ii) {
            bodySize += 114 + ((EvpsNodeInfo)node.getNodeList().get(ii)).getPhaseList().size() * 32;
        }
        this.body = ByteBuffer.allocate(bodySize);
        this.body.order(ByteOrder.BIG_ENDIAN);
        this.setLength(bodySize);
        this.body.putShort((short)(lcList & 0xFFFF));
        for (ii = 0; ii < lcList; ++ii) {
            EvpsNodeInfo nodeInfo = (EvpsNodeInfo)node.getNodeList().get(ii);
            this.body.putInt((int)nodeInfo.getNodeId().longValue());
            byte[] intNameArr = new byte[100];
            ByteUtils.copyStringToByteArray((byte[])intNameArr, (String)nodeInfo.getNodeNm());
            this.body.put(intNameArr);
            this.body.putInt((int)(nodeInfo.getLat() * 1000000.0));
            this.body.putInt((int)(nodeInfo.getLng() * 1000000.0));
            int phaseList = nodeInfo.getPhaseList().size();
            this.body.putShort((short)(phaseList & 0xFFFF));
            for (int jj = 0; jj < phaseList; ++jj) {
                EvpsPhaseInfo phaseInfo = (EvpsPhaseInfo)nodeInfo.getPhaseList().get(jj);
                this.body.put(phaseInfo.getRing().byteValue());
                this.body.put(phaseInfo.getPhaseNo().byteValue());
                this.body.put(phaseInfo.getPlanClass().byteValue());
                this.body.put(phaseInfo.getFlowNo().byteValue());
                this.body.putInt((int)(phaseInfo.getHeadLat() * 1000000.0));
                this.body.putInt((int)(phaseInfo.getHeadLng() * 1000000.0));
                this.body.putInt((int)(phaseInfo.getMidLat() * 1000000.0));
                this.body.putInt((int)(phaseInfo.getMidLng() * 1000000.0));
                this.body.putInt((int)(phaseInfo.getEndLat() * 1000000.0));
                this.body.putInt((int)(phaseInfo.getEndLng() * 1000000.0));
                this.body.putShort((short)(phaseInfo.getHeadAngle().shortValue() & 0xFFFF));
                this.body.putShort((short)(phaseInfo.getEndAngle().shortValue() & 0xFFFF));
            }
        }
    }

    public String getMsgType() {
        return "EvpsNode";
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer frame = ByteBuffer.allocate(this.getHeadSize() + this.getBodySize());
        frame.put(this.getHeadBuffer().array());
        frame.put(this.getBodyBuffer().array());
        return frame;
    }
}

