/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.xnet.client.process.request;

import com.evps.comm.local.xnet.client.process.request.EvpsFrameData;
import com.evps.common.kafka.dto.EvpsRouteInfo;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.protocol.eEvpsOpCode;
import com.its.common.utils.ByteUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EvpsService
extends EvpsFrameData {
    public EvpsService(KafkaEvpsServiceDto service) {
        super(eEvpsOpCode.EVPS_SERVICE.getValue(), service.getServiceId());
        int routeList = service.getRouteList().size();
        int bodySize = routeList * 8 + 180;
        this.body = ByteBuffer.allocate(bodySize);
        this.body.order(ByteOrder.BIG_ENDIAN);
        this.setLength(bodySize);
        byte[] evNoArr = new byte[10];
        ByteUtils.copyStringToByteArray((byte[])evNoArr, (String)service.getEvNo());
        this.body.put(evNoArr);
        this.body.putInt((int)(service.getCurLat() * 1000000.0));
        this.body.putInt((int)(service.getCurLng() * 1000000.0));
        byte[] serviceNameArr = new byte[100];
        ByteUtils.copyStringToByteArray((byte[])serviceNameArr, (String)service.getServiceNm());
        this.body.put(serviceNameArr);
        this.body.putInt((int)(service.getArrLat() * 1000000.0));
        this.body.putInt((int)(service.getArrLng() * 1000000.0));
        this.body.putInt(service.getVehLen());
        byte[] ocrNoArr = new byte[20];
        ByteUtils.copyStringToByteArray((byte[])ocrNoArr, (String)service.getOcrNo());
        this.body.put(ocrNoArr);
        byte[] ocrTypeArr = new byte[20];
        ByteUtils.copyStringToByteArray((byte[])ocrTypeArr, (String)service.getOcrType());
        this.body.put(ocrTypeArr);
        this.body.putInt(service.getArrTm());
        this.body.putInt(service.getServiceDist());
        this.body.putShort((short)(routeList & 0xFFFF));
        for (int ii = 0; ii < routeList; ++ii) {
            EvpsRouteInfo routeInfo = (EvpsRouteInfo)service.getRouteList().get(ii);
            this.body.putInt((int)(routeInfo.getLat() * 1000000.0));
            this.body.putInt((int)(routeInfo.getLng() * 1000000.0));
        }
    }

    public String getMsgType() {
        return "EvpsService";
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer frame = ByteBuffer.allocate(this.getHeadSize() + this.getBodySize());
        frame.put(this.getHeadBuffer().array());
        frame.put(this.getBodyBuffer().array());
        return frame;
    }
}

