/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.xnet.server;

import com.evps.comm.server.config.ApplicationConfig;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.comm.server.xnet.server.EvpsCommServerInitializer;
import com.its.common.network.NettyUtils;
import com.its.common.network.tcp.server.NettyServerConfig;
import com.its.common.network.tcp.server.NettyTcpServer;
import com.its.common.utils.OsPlatform;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.epoll.Epoll;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EvpsCommServerService
extends NettyTcpServer {
    private static final Logger log = LoggerFactory.getLogger(EvpsCommServerService.class);
    private final ApplicationConfig config;
    private final ApplicationRepository applicationRepository;
    private final DbmsDataProcess dbmsDataProcess;

    public EvpsCommServerService(ApplicationConfig config, ApplicationRepository applicationRepository, DbmsDataProcess dbmsDataProcess) {
        super((NettyServerConfig)config);
        this.config = config;
        this.applicationRepository = applicationRepository;
        this.dbmsDataProcess = dbmsDataProcess;
    }

    @PostConstruct
    public void initialize() {
        super.setChannelInitializer((ChannelInitializer)new EvpsCommServerInitializer(this.config, this.applicationRepository, this.dbmsDataProcess));
        if (!OsPlatform.isWindows() && !Epoll.isAvailable()) {
            log.warn("EvpsCommServerService.initialize: {}", (Object)Epoll.unavailabilityCause().toString());
        }
        if (NettyUtils.isEpollAvailable()) {
            log.info("\uc11c\ubc84\uac00 \ub9ac\ub205\uc2a4 EPOLL \ubaa8\ub4dc\uc5d0\uc11c \uc2e4\ud589\ub429\ub2c8\ub2e4.");
        } else {
            log.info("\uc11c\ubc84\uac00 \uc708\ub3c4\uc6b0 NIO \ubaa8\ub4dc\uc5d0\uc11c \uc2e4\ud589\ub429\ub2c8\ub2e4.");
        }
    }
}

