/*
 * Decompiled with CFR 0.152.
 */
package com.evps.simulator.kafka.producer.scheduler;

import com.evps.simulator.kafka.producer.service.EvpsKafkaProducerManagerService;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class ApplicationScheduler {
    private static final Logger log = LoggerFactory.getLogger(ApplicationScheduler.class);
    private final EvpsKafkaProducerManagerService evpsKafkaProducerManagerService;

    @PreDestroy
    public void onShutDown() {
        log.info("ApplicationScheduler.onShutDown: Shutting down...");
    }

    @Async
    @Scheduled(cron="10 0/10 * * * *")
    public void sendEvpsKafkaSimulatorData() {
        try {
            this.evpsKafkaProducerManagerService.run();
        }
        catch (Exception e) {
            log.error("ApplicationScheduler.sendEvpsKafkaSimulatorData: Exception {}", (Object)e.getMessage());
        }
    }

    public ApplicationScheduler(EvpsKafkaProducerManagerService evpsKafkaProducerManagerService) {
        this.evpsKafkaProducerManagerService = evpsKafkaProducerManagerService;
    }
}

