/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.config;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@MapperScan(basePackages={"com.evps.comm.server.dao.mapper"}, sqlSessionFactoryRef="sqlSessionFactory")
@EnableTransactionManagement
public class DatabaseConfig {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConfig.class);
    @Value(value="${spring.datasource.hikari.mapper-locations:classpath:mybatis/mapper/**/*.xml}")
    String mapperLocations;

    @PostConstruct
    private void init() {
        if (this.mapperLocations.trim().isEmpty()) {
            this.mapperLocations = "classpath:mybatis/mapper/**/*.xml";
        }
        log.info("mapperLocations: {}", (Object)this.mapperLocations);
    }

    @Primary
    @Bean(name={"dataSource"})
    @ConfigurationProperties(prefix="spring.datasource.hikari")
    public DataSource dataSource() {
        return DataSourceBuilder.create().build();
    }

    @Primary
    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactoryBean(@Autowired @Qualifier(value="dataSource") DataSource dataSource, ApplicationContext applicationContext) throws Exception {
        SqlSessionFactoryBean factoryBean = new SqlSessionFactoryBean();
        factoryBean.setDataSource(dataSource);
        factoryBean.setMapperLocations(applicationContext.getResources(this.mapperLocations));
        return factoryBean.getObject();
    }

    @Primary
    @Bean(name={"sqlSession"})
    public SqlSessionTemplate sqlSession(@Autowired @Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Primary
    @Bean(name={"sqlSessionTemplate"})
    public SqlSessionTemplate sqlSessionTemplate(@Autowired @Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Primary
    @Bean(name={"transactionManager"})
    public DataSourceTransactionManager transactionManager(@Autowired @Qualifier(value="dataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    public String toString() {
        return "DatabaseConfig(mapperLocations=" + this.mapperLocations + ")";
    }
}

