/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.service;

import com.evps.comm.server.config.ApplicationConfig;
import com.evps.comm.server.dao.mapper.ProcessMapper;
import com.evps.comm.server.process.dbms.DbmsData;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.its.common.spring.SpringUtils;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class UnitSystService {
    private static final Logger log = LoggerFactory.getLogger(UnitSystService.class);
    private final DbmsDataProcess dbmsDataProcess;
    private final ProcessMapper mapper;
    private String processId;

    @PostConstruct
    private void init() {
        log.info("UnitSystService.init: start.");
        ApplicationConfig applicationConfig = (ApplicationConfig)SpringUtils.getBean(ApplicationConfig.class);
        this.processId = applicationConfig.getProcessId();
        this.updateUnitSystStart();
        log.info("UnitSystService.init. processId: {}.", (Object)this.processId);
        log.info("UnitSystService.init: ..end.");
    }

    @PreDestroy
    public void destroyService() {
        log.error("UnitSystService.destroy. system terminated.......");
        this.updateUnitSystStop();
    }

    public void updateUnitSystStart() {
        String keyData = "unit";
        MDC.put((String)"id", (String)keyData);
        this.mapper.updateProcessRun(this.processId);
        MDC.remove((String)keyData);
        MDC.clear();
    }

    public void updateUnitSystStop() {
        String keyData = "unit";
        MDC.put((String)"id", (String)keyData);
        this.mapper.updateProcessStop(this.processId);
        MDC.remove((String)keyData);
        MDC.clear();
    }

    public void updateUnitSystStts() {
        String keyData = "unit";
        MDC.put((String)"id", (String)keyData);
        this.dbmsDataProcess.add(new DbmsData(0, ApplicationRepository.center, (Object)this.processId));
        MDC.remove((String)keyData);
        MDC.clear();
    }

    public DbmsDataProcess getDbmsDataProcess() {
        return this.dbmsDataProcess;
    }

    public ProcessMapper getMapper() {
        return this.mapper;
    }

    public String getProcessId() {
        return this.processId;
    }

    public UnitSystService(DbmsDataProcess dbmsDataProcess, ProcessMapper mapper) {
        this.dbmsDataProcess = dbmsDataProcess;
        this.mapper = mapper;
    }
}

