/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.xnet.server.process.response;

import com.evps.comm.server.kafka.KafkaProducerService;
import com.evps.comm.server.process.dbms.DbmsData;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.kafka.dto.KafkaEvpsEventDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceEndDto;
import com.evps.common.protocol.response.EvpsCommResponse;
import com.evps.common.protocol.response.RecvPacketDto;
import com.evps.common.utils.EvpsUtils;
import com.its.common.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvpsServiceEnd
implements EvpsCommResponse {
    private static final Logger log = LoggerFactory.getLogger(EvpsServiceEnd.class);
    private final DbmsDataProcess dbmsDataProcess;
    private final KafkaProducerService kafkaProducerService;

    public boolean response(RecvPacketDto packet) {
        boolean result = true;
        try {
            log.info("[{}]. EvpsServiceEnd.response. Service Id: {}.", (Object)packet.getCenter().getLogKey(), (Object)packet.getPacket().getServiceId());
            return this.makeData(packet, packet.getPacket().getBuffer());
        }
        catch (Exception e) {
            log.error("[{}]. EvpsServiceEnd.response: Service Id: {}, Exception. will be closed. {}", new Object[]{packet.getCenter().getLogKey(), packet.getPacket().getServiceId(), e.getMessage()});
            result = false;
            return result;
        }
    }

    private KafkaEvpsServiceEndDto getData(String serviceId, byte[] buffer, int idx, String clctDt) {
        int reason = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        return KafkaEvpsServiceEndDto.builder().serviceId(serviceId).clctDt(clctDt).reason(Integer.valueOf(reason)).build();
    }

    private boolean makeData(RecvPacketDto packet, byte[] buffer) {
        EvpsCenter center = packet.getCenter();
        if (buffer == null || buffer.length != 4) {
            log.error("[{}]. EvpsServiceEnd.response: Service Id: {}, Data Length Error: Required data length({}), Cur({}). will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), 4, buffer == null ? 0 : buffer.length});
            return false;
        }
        String clctDt = EvpsUtils.getClctDt();
        KafkaEvpsServiceEndDto data = this.getData(packet.getPacket().getServiceId(), buffer, 0, clctDt);
        log.info("[{}]. EvpsServiceEnd.response: Service Id: {}, {}", new Object[]{center.getLogKey(), data.getServiceId(), data});
        KafkaEvpsEventDto event = KafkaEvpsEventDto.builder().serviceId(data.getServiceId()).clctDt(clctDt).eventCd(Integer.valueOf(2)).build();
        KafkaEvpsServiceDto service = ApplicationRepository.getService((String)data.getServiceId());
        if (service == null) {
            log.error("[{}]. EvpsServiceEnd.response: Service Id: {}, Not Found Service Information.", (Object)center.getLogKey(), (Object)data.getServiceId());
            service = new KafkaEvpsServiceDto();
            service.setServiceId(data.getServiceId());
            service.setEvNo("-");
            service.setCurLat(Double.valueOf(0.0));
            service.setCurLng(Double.valueOf(0.0));
            service.setCurSpd(Integer.valueOf(0));
            service.setServiceDist(Integer.valueOf(0));
        }
        service.updateLastCommTime();
        service.setStatusCd(data.getReason());
        event.setEvNo(service.getEvNo());
        event.setCurLat(service.getCurLat());
        event.setCurLng(service.getCurLng());
        event.setCurSpd(service.getCurSpd());
        event.setRemDist(service.getServiceDist());
        TimeUtils.sleep((long)500L);
        ApplicationRepository.delService((String)service.getServiceId());
        this.kafkaProducerService.sendEvpsEventTopic(event);
        this.kafkaProducerService.sendEvpsServiceEndTopic(data);
        this.dbmsDataProcess.add(new DbmsData(12, center, (Object)event));
        TimeUtils.sleep((long)200L);
        this.dbmsDataProcess.add(new DbmsData(11, center, (Object)service));
        return true;
    }

    public EvpsServiceEnd(DbmsDataProcess dbmsDataProcess, KafkaProducerService kafkaProducerService) {
        this.dbmsDataProcess = dbmsDataProcess;
        this.kafkaProducerService = kafkaProducerService;
    }
}

