/*
 * Decompiled with CFR 0.152.
 */
package com.evps.consumer.service;

import com.evps.common.kafka.dto.KafkaEvpsData;
import com.evps.consumer.service.KafkaUticEvpsConsumerWorker;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.support.serializer.JsonDeserializer;

public class KafkaConsumerService {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerService.class);
    private final String topicName;
    private final String bootstrapServers;
    private final String groupId;
    private ConcurrentMessageListenerContainer<String, String> kafkaListenerContainer;
    private ConcurrentMessageListenerContainer<String, KafkaEvpsData> uticEvpsListenerContainer;

    public void start() {
        log.info("Starting Kafka Consumer: bootstrapServers: {}, topic: {}, group: {}", new Object[]{this.bootstrapServers, this.topicName, this.groupId});
        ContainerProperties containerProperties = new ContainerProperties(new String[]{this.topicName});
        containerProperties.setGroupId(this.groupId + "Z");
        containerProperties.setPollTimeout(5000L);
        containerProperties.setMessageListener((Object)new KafkaUticEvpsConsumerWorker());
        containerProperties.setConsumerRebalanceListener((ConsumerRebalanceListener)new /* Unavailable Anonymous Inner Class!! */);
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(this.getConsumerStringPropertiesMap());
        this.kafkaListenerContainer = new ConcurrentMessageListenerContainer((ConsumerFactory)consumerFactory, containerProperties);
        this.kafkaListenerContainer.setBeanName("uticEvpsListenerContainer");
        this.kafkaListenerContainer.setConcurrency(1);
        this.kafkaListenerContainer.setErrorHandler((thrownException, data) -> {
            log.error("uticEvpsListenerContainer error: {}", (Object)thrownException.getMessage());
            this.kafkaListenerContainer.stop();
            this.kafkaListenerContainer.start();
        });
        this.kafkaListenerContainer.start();
    }

    public Map<String, Object> getConsumerPropertiesMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bootstrap.servers", this.bootstrapServers);
        properties.put("group.id", this.groupId);
        properties.put("enable.auto.commit", "true");
        properties.put("auto.commit.interval.ms", 1);
        properties.put("session.timeout.ms", "10000");
        properties.put("auto.offset.reset", "latest");
        properties.put("max.poll.interval.ms", "100");
        properties.put("check.crcs", false);
        properties.put("max.poll.records", 1);
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", JsonDeserializer.class);
        properties.put("spring.json.trusted.packages", "*");
        return properties;
    }

    public Map<String, Object> getConsumerStringPropertiesMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bootstrap.servers", this.bootstrapServers);
        properties.put("group.id", this.groupId);
        properties.put("enable.auto.commit", "true");
        properties.put("auto.commit.interval.ms", 1);
        properties.put("session.timeout.ms", "10000");
        properties.put("auto.offset.reset", "latest");
        properties.put("max.poll.interval.ms", "100");
        properties.put("check.crcs", false);
        properties.put("max.poll.records", 1);
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        properties.put("spring.json.trusted.packages", "*");
        return properties;
    }

    public void shutdown() {
        try {
            if (this.uticEvpsListenerContainer != null) {
                this.uticEvpsListenerContainer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public KafkaConsumerService(String topicName, String bootstrapServers, String groupId) {
        this.topicName = topicName;
        this.bootstrapServers = bootstrapServers;
        this.groupId = groupId;
    }
}

