/*
 * Decompiled with CFR 0.152.
 */
package com.evps.consumer;

import com.evps.consumer.service.KafkaConsumerService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;

@SpringBootApplication(exclude={DataSourceAutoConfiguration.class})
public class EvpCommConsumerApplication
implements ApplicationRunner,
ApplicationListener<ContextClosedEvent> {
    private static final Logger log = LoggerFactory.getLogger(EvpCommConsumerApplication.class);
    private static String bootstrapServers = "172.24.0.30:9092,172.24.0.31:9093,172.24.0.32:9094";
    private static String topicName = "utic-evps";
    private static String consumerGroup = "evps-consumer";
    private KafkaConsumerService kafkaConsumerService = null;

    public static void main(String[] args) {
        SpringApplication application = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{EvpCommConsumerApplication.class}).build();
        application.setBannerMode(Banner.Mode.OFF);
        application.run(args);
    }

    public void run(ApplicationArguments args) throws Exception {
        Set optionNames = args.getOptionNames();
        boolean helpOptions = args.containsOption("help");
        if (helpOptions) {
            this.usage();
            return;
        }
        for (String optionName : optionNames) {
            List optionValues = args.getOptionValues(optionName);
            for (String optionValue : optionValues) {
                if ("servers".equals(optionName)) {
                    bootstrapServers = optionValue;
                    continue;
                }
                if ("group".equals(optionName)) {
                    consumerGroup = optionValue;
                    continue;
                }
                if (!"topic".equals(optionName)) continue;
                if ("test".equals(optionValue)) {
                    topicName = "utic-evps-test";
                    continue;
                }
                if ("sim".equals(optionValue)) {
                    topicName = "utic-evps-sim";
                    continue;
                }
                topicName = "xxx";
            }
            if ("utic-evps-test".equals(topicName) || "utic-evps".equals(topicName) || "utic-evps-sim".equals(topicName)) continue;
            log.error("tipic name error: {}", (Object)topicName);
            this.usage();
            return;
        }
        this.kafkaConsumerService = new KafkaConsumerService(topicName, bootstrapServers, consumerGroup);
        this.kafkaConsumerService.start();
    }

    private void usage() {
        log.info("\r\n\n\n\n\nUsage: java -jar evps-consumer --servers=xxx.xxx.xxx.xxx:nnnn --topic=test --group:evps-consumer\n   --servers=kafka bootstrap server[optional, default=172.24.0.30:9092,172.24.0.31:9093,172.24.0.32:9094]\n   --topic=consumer topic name[optional[sim/test], default=utic-evps, test=utic-evps-test, sim=utic-evps-sim]\n   --group=kafka consumer group name[optional, default=evps-consumer]\n\n\n\n");
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (this.kafkaConsumerService != null) {
                this.kafkaConsumerService.shutdown();
            }
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage());
        }
        log.error("Application Terminated: {}, {}", (Object)sdfDate.format(new Date()), (Object)event);
    }
}

