/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.config;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableAutoConfiguration(exclude={DataSourceAutoConfiguration.class})
@ConfigurationProperties(prefix="application")
public class ApplicationConfig {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfig.class);
    private String processId = "evps-comm-local";
    private String regionId = "186";
    private String serverIp = "10.4.4.51";
    private int serverPort = 7800;
    private int connectionTimeout = 5;
    private int retryConnectSeconds = 60;
    private int netPingSeconds = 30;

    @PostConstruct
    private void init() {
        if (this.connectionTimeout < 5) {
            this.connectionTimeout = 5;
        }
        if (this.connectionTimeout > 10) {
            this.connectionTimeout = 10;
        }
        if (this.retryConnectSeconds < 5) {
            this.retryConnectSeconds = 10;
        }
        if (this.retryConnectSeconds > 60) {
            this.retryConnectSeconds = 60;
        }
        if (this.netPingSeconds < 30) {
            this.netPingSeconds = 30;
        }
        if (this.netPingSeconds > 60) {
            this.netPingSeconds = 60;
        }
        log.info("[{}] -------------------------", (Object)this.getClass().getSimpleName());
        log.info("[{}]           server Ip: {}", (Object)this.getClass().getSimpleName(), (Object)this.serverIp);
        log.info("[{}]         server Port: {}", (Object)this.getClass().getSimpleName(), (Object)this.serverPort);
        log.info("[{}]   ConnectionTimeout: {}", (Object)this.getClass().getSimpleName(), (Object)this.connectionTimeout);
        log.info("[{}] RetryConnectSeconds: {}", (Object)this.getClass().getSimpleName(), (Object)this.retryConnectSeconds);
        log.info("{}", (Object)super.toString());
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getRetryConnectSeconds() {
        return this.retryConnectSeconds;
    }

    public int getNetPingSeconds() {
        return this.netPingSeconds;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setRetryConnectSeconds(int retryConnectSeconds) {
        this.retryConnectSeconds = retryConnectSeconds;
    }

    public void setNetPingSeconds(int netPingSeconds) {
        this.netPingSeconds = netPingSeconds;
    }

    public String toString() {
        return "ApplicationConfig(processId=" + this.getProcessId() + ", regionId=" + this.getRegionId() + ", serverIp=" + this.getServerIp() + ", serverPort=" + this.getServerPort() + ", connectionTimeout=" + this.getConnectionTimeout() + ", retryConnectSeconds=" + this.getRetryConnectSeconds() + ", netPingSeconds=" + this.getNetPingSeconds() + ")";
    }
}

