/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.scheduler;

import com.evps.comm.local.service.EvpsLocalClientManagerService;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class ApplicationScheduler {
    private static final Logger log = LoggerFactory.getLogger(ApplicationScheduler.class);
    private final EvpsLocalClientManagerService evpsLocalClientManagerService;

    @PreDestroy
    public void onShutDown() {
        log.info("ApplicationScheduler.onShutDown: Shutting down...");
    }

    @Async
    @Scheduled(cron="10 0/10 * * * *")
    public void sendEvpsCommLocalData() {
        try {
            this.evpsLocalClientManagerService.run();
        }
        catch (Exception e) {
            log.error("ApplicationScheduler.sendEvpsCommLocalData: Exception {}", (Object)e.getMessage());
        }
    }

    @Async
    @Scheduled(cron="0/5 * * * * *")
    public void sendEvpsPing() {
        try {
            this.evpsLocalClientManagerService.sendPing();
        }
        catch (Exception e) {
            log.error("ApplicationScheduler.sendEvpsPing: Exception {}", (Object)e.getMessage());
        }
    }

    public ApplicationScheduler(EvpsLocalClientManagerService evpsLocalClientManagerService) {
        this.evpsLocalClientManagerService = evpsLocalClientManagerService;
    }
}

