/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.repository;

import com.evps.comm.server.dao.mapper.EvpsCenterMapper;
import com.evps.comm.server.dao.mapper.EvpsServiceMapper;
import com.evps.comm.server.entity.TbEvpsCenter;
import com.evps.comm.server.entity.TbEvpsService;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.dto.NetState;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.its.common.network.NettyUtils;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional(rollbackFor={Exception.class})
public class ApplicationRepository {
    private static final Logger log = LoggerFactory.getLogger(ApplicationRepository.class);
    public static final AttributeKey<EvpsCenter> SIG_REGION_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"Region");
    public static final EvpsCenter center = EvpsCenter.builder().idx(0).useYn(true).centerId("L00").centerNm("UTIC EVPS \uc13c\ud130").ipAddress("127.0.0.1").netState(new NetState()).dump(false).build();
    private static final ConcurrentHashMap<String, KafkaEvpsServiceDto> serviceMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, EvpsCenter> centerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, EvpsCenter> ipAddrMap = new ConcurrentHashMap();
    private final EvpsCenterMapper mapper;
    private final EvpsServiceMapper serviceMapper;
    private final DbmsDataProcess dbmsDataProcess;

    public static void addService(String serviceId, KafkaEvpsServiceDto service) {
        serviceMap.put(serviceId, service);
    }

    public static void delService(String serviceId) {
        serviceMap.remove(serviceId);
    }

    public static KafkaEvpsServiceDto getService(String serviceId) {
        return (KafkaEvpsServiceDto)serviceMap.get(serviceId);
    }

    public static void closeChannel(EvpsCenter center, Channel channel) {
        try {
            if (center == null || center.getNetState().getState() > 1) {
                // empty if block
            }
            if (channel != null) {
                channel.flush();
                channel.disconnect();
                channel.close();
            }
        }
        catch (Exception e) {
            log.error("ApplicationRepository.closeChannel Exception: {}", (Object)e.getMessage());
        }
    }

    public static void setCenterObject(Channel channel, EvpsCenter center) {
        channel.attr(SIG_REGION_ATTRIBUTE_KEY).set((Object)center);
    }

    public static EvpsCenter getCenterObject(Channel channel) {
        EvpsCenter center = (EvpsCenter)channel.attr(SIG_REGION_ATTRIBUTE_KEY).get();
        if (center == null) {
            log.warn("ApplicationRepository.getCenterObject: {}, Not Found Channel Object. Will be closed.", (Object)NettyUtils.getAddress((Channel)channel));
            ApplicationRepository.closeChannel(null, (Channel)channel);
            return null;
        }
        return center;
    }

    public EvpsCenter getCenter(String centerId) {
        return (EvpsCenter)this.centerMap.get(centerId);
    }

    @PostConstruct
    private void init() {
    }

    public EvpsCenter getIpAddrMap(String ipAddr) {
        return (EvpsCenter)this.ipAddrMap.get(ipAddr);
    }

    private void initCenterMap() {
        try {
            for (Map.Entry e : this.centerMap.entrySet()) {
                EvpsCenter obj = (EvpsCenter)e.getValue();
                obj.setUseYn(false);
            }
        }
        catch (Exception e) {
            log.error("ApplicationRepository.initCenterMap: Exception: {}.", (Object)e.toString());
        }
    }

    public void loadDb() {
        this.loadCenterInfo();
    }

    public void initEvpsCenterStts() {
        this.centerMap.forEach((key, center) -> this.mapper.updateCommInit(center.getCenterId()));
    }

    private void loadCenterInfo() {
        this.initCenterMap();
        try {
            List lists = this.mapper.selectAll();
            for (TbEvpsCenter entity : lists) {
                EvpsCenter dto = entity.toDto();
                EvpsCenter center = (EvpsCenter)this.centerMap.get(dto.getCenterId());
                if (center != null) {
                    String oldIpAddress = center.getIpAddress();
                    center.update(dto);
                    if (center.getIpAddress().equals(oldIpAddress)) continue;
                    this.ipAddrMap.remove(oldIpAddress);
                    this.ipAddrMap.put(center.getIpAddress(), center);
                    continue;
                }
                center = dto;
                this.centerMap.put(dto.getCenterId(), center);
                this.ipAddrMap.put(dto.getIpAddress(), center);
            }
        }
        catch (Exception e) {
            log.error("ApplicationRepository.loadCenterInfo: {}.", (Object)e.toString());
        }
    }

    public void loadServices() {
        try {
            List lists = this.serviceMapper.selectAll();
            log.info("ApplicationRepository.loadServices: {} EA", (Object)lists.size());
            for (TbEvpsService entity : lists) {
                KafkaEvpsServiceDto dto = entity.toDto();
                String centerId = dto.getServiceId().substring(0, 3);
                EvpsCenter center = (EvpsCenter)this.centerMap.get(centerId);
                dto.setCenterObj((Object)center);
                ApplicationRepository.addService((String)dto.getServiceId(), (KafkaEvpsServiceDto)dto);
            }
        }
        catch (Exception e) {
            log.error("ApplicationRepository.loadServices: {}.", (Object)e.toString());
        }
    }

    @PreDestroy
    public void destroyService() {
        log.error("ApplicationRepository.destroy. system terminated.......");
        this.centerMap.forEach((key, center) -> this.mapper.updateCommStateDisconnect(center.getCenterId()));
    }

    public void reportCenterSessions() {
        log.info("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        log.info("Center IpAddress       NetState Connected Connect_Time         Disconnect_Time      Remote_Address                    Dump  Name       ");
        log.info("-----------------------------------------------------------------------------------------------------------------------------------------");
        ArrayList keySet = new ArrayList(this.centerMap.keySet());
        Collections.sort(keySet);
        for (String key : keySet) {
            EvpsCenter center = (EvpsCenter)this.centerMap.get(key);
            String channelIpAddress = center.getNetState().isActive() ? NettyUtils.getRemoteAddress((Channel)center.getNetState().getChannel()) : "---";
            log.info("{}", (Object)String.format("%-6s %-15s %-8s %9d %s  %s  %-33s %-5s %s", center.getCenterId(), center.getIpAddress(), center.getNetState().isActive(), center.getNetState().getConnectCount(), center.getNetState().getConnectTimeString(), center.getNetState().getDisconnectTimeString(), channelIpAddress, center.isDump(), center.getCenterNm()));
        }
        log.info("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
    }

    public ConcurrentHashMap<String, EvpsCenter> getCenterMap() {
        return this.centerMap;
    }

    public ConcurrentHashMap<String, EvpsCenter> getIpAddrMap() {
        return this.ipAddrMap;
    }

    public EvpsCenterMapper getMapper() {
        return this.mapper;
    }

    public EvpsServiceMapper getServiceMapper() {
        return this.serviceMapper;
    }

    public DbmsDataProcess getDbmsDataProcess() {
        return this.dbmsDataProcess;
    }

    public ApplicationRepository(EvpsCenterMapper mapper, EvpsServiceMapper serviceMapper, DbmsDataProcess dbmsDataProcess) {
        this.mapper = mapper;
        this.serviceMapper = serviceMapper;
        this.dbmsDataProcess = dbmsDataProcess;
    }

    public static ConcurrentHashMap<String, KafkaEvpsServiceDto> getServiceMap() {
        return serviceMap;
    }
}

