/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.scheduler;

import com.evps.comm.server.config.TraceConfig;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.comm.server.service.EvpsServiceManagerService;
import com.evps.comm.server.service.UnitSystService;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class ApplicationScheduler {
    private static final Logger log = LoggerFactory.getLogger(ApplicationScheduler.class);
    private final TraceConfig traceConfig;
    private final UnitSystService unitSystService;
    private final ApplicationRepository applicationRepository;
    private final EvpsServiceManagerService evpsServiceManagerService;

    @PreDestroy
    public void onShutDown() {
        log.info("ApplicationScheduler.onShutDown: Shutting down...");
    }

    @Async
    @Scheduled(cron="0 * * * * *")
    public void updateProcessState() {
        try {
            this.unitSystService.updateUnitSystStts();
        }
        catch (Exception e) {
            log.error("ApplicationScheduler.updateProcessState: Exception {}", (Object)e.getMessage());
        }
    }

    @Async
    @Scheduled(cron="30 * * * * *")
    public void loadTraceConfig() {
        try {
            this.traceConfig.loadTraceInfo();
        }
        catch (Exception e) {
            log.error("ApplicationScheduler.loadTraceConfig: Exception {}", (Object)e.getMessage());
        }
    }

    @Async
    @Scheduled(cron="0/30 * * * * *")
    public void serviceMangerSchedule() {
        try {
            this.evpsServiceManagerService.checkServiceTimeout();
        }
        catch (Exception e) {
            log.error("ApplicationScheduler.serviceMangerSchedule: Exception {}", (Object)e.getMessage());
        }
    }

    @Async
    @Scheduled(cron="20 * * * * *")
    public void reportCenterSessions() {
        try {
            this.applicationRepository.reportCenterSessions();
        }
        catch (Exception e) {
            log.error("ApplicationScheduler.reportCenterSessions: Exception {}", (Object)e.getMessage());
        }
    }

    @Async
    @Scheduled(cron="10 0/5 * * * *")
    public void loadBaseDatabase() {
        try {
            this.applicationRepository.loadDb();
        }
        catch (Exception e) {
            log.error("ApplicationScheduler.loadBaseDatabase: Exception {}", (Object)e.getMessage());
        }
    }

    public ApplicationScheduler(TraceConfig traceConfig, UnitSystService unitSystService, ApplicationRepository applicationRepository, EvpsServiceManagerService evpsServiceManagerService) {
        this.traceConfig = traceConfig;
        this.unitSystService = unitSystService;
        this.applicationRepository = applicationRepository;
        this.evpsServiceManagerService = evpsServiceManagerService;
    }
}

