/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.xnet.server.handler;

import com.evps.comm.server.entity.TbRegionCenterComm;
import com.evps.comm.server.process.dbms.DbmsData;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.comm.server.xnet.server.process.work.DataPacketProcess;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.protocol.EvpsCommPacket;
import com.evps.common.protocol.eEvpsOpCode;
import com.evps.common.protocol.response.RecvPacketDto;
import com.its.common.network.NettyUtils;
import com.its.common.utils.ByteUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class EvpsCommServerInboundMessageHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(EvpsCommServerInboundMessageHandler.class);
    private final DataPacketProcess dataPacketProcess;
    private final DbmsDataProcess dbmsDataProcess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf byteBuf) throws Exception {
        long recvTime = System.currentTimeMillis();
        EvpsCenter center = ApplicationRepository.getCenterObject((Channel)ctx.channel());
        if (center == null) {
            log.error("[{}]. RECV: Not Found Channel Center Object... Oops Will be closed.", (Object)NettyUtils.getAddress((Channel)ctx.channel()));
            ApplicationRepository.closeChannel(null, (Channel)ctx.channel());
            return;
        }
        boolean isError = false;
        try {
            MDC.put((String)"id", (String)center.getLogKey());
            EvpsCommPacket evpsCommPacket = new EvpsCommPacket(center, byteBuf);
            if (center.isDump()) {
                log.info("[{}]. RECV: {} Bytes. {}\r\nService Id: {}. Time: {}. Head: {} Bytes. Body: {} Bytes. {}{}", new Object[]{center.getLogKey(), evpsCommPacket.getFrameLength(), eEvpsOpCode.getValue((byte)evpsCommPacket.getOpCode()), evpsCommPacket.getServiceId(), evpsCommPacket.getCommDate(), evpsCommPacket.getHeadBuffer().length, evpsCommPacket.getBuffer().length, ByteUtils.byteArrayToHex((byte[])evpsCommPacket.getHeadBuffer()), ByteUtils.byteArrayToHex((byte[])evpsCommPacket.getBuffer())});
            } else {
                log.info("[{}]. RECV: {} Bytes. {}", new Object[]{center.getLogKey(), evpsCommPacket.getFrameLength(), eEvpsOpCode.getValue((byte)evpsCommPacket.getOpCode())});
            }
            if (!evpsCommPacket.isValid()) {
                log.error("[{}]. RECV: {} Bytes. Packet Validation Error: will be closed.", (Object)center.getIpAddress(), (Object)evpsCommPacket.getFrameLength());
                isError = true;
            } else {
                RecvPacketDto packet = RecvPacketDto.builder().recvTime(recvTime).center(center).packet(evpsCommPacket).build();
                center.getNetState().setLastRecvTime();
                this.dataPacketProcess.add(packet);
                TbRegionCenterComm stts = TbRegionCenterComm.builder().centerId(center.getCenterId()).commState(2).opCode(evpsCommPacket.getOpCode()).opCodeDesc(evpsCommPacket.getOpCodeDesc()).build();
                this.dbmsDataProcess.add(new DbmsData(1, center, (Object)stts));
            }
        }
        catch (Exception e) {
            log.error("[{}]. RECV: Exception Error: will be closed: {}.", (Object)center.getLogKey(), (Object)e.getMessage());
            isError = true;
        }
        finally {
            if (isError) {
                ApplicationRepository.closeChannel((EvpsCenter)center, (Channel)ctx.channel());
            }
            MDC.remove((String)center.getLogKey());
            MDC.clear();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        EvpsCenter center = ApplicationRepository.getCenterObject((Channel)ctx.channel());
        if (center == null) {
            log.error("channelInactive: Unknown Center: [{}].", (Object)NettyUtils.getAddress((Channel)ctx.channel()));
            return;
        }
        MDC.put((String)"id", (String)center.getLogKey());
        log.info("[{}]. channelInactive: [{}]. CenterId: {}.", new Object[]{center.getLogKey(), NettyUtils.getAddress((Channel)ctx.channel()), center.getCenterId()});
        center.getNetState().disConnect();
        ApplicationRepository.setCenterObject((Channel)ctx.channel(), null);
        ctx.fireChannelInactive();
        TbRegionCenterComm stts = TbRegionCenterComm.builder().centerId(center.getCenterId()).commState(1).opCode((byte)0).opCodeDesc("STOP").build();
        this.dbmsDataProcess.add(new DbmsData(1, center, (Object)stts));
        MDC.remove((String)center.getLogKey());
        MDC.clear();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object e) throws Exception {
        IdleStateEvent evt;
        EvpsCenter center = ApplicationRepository.getCenterObject((Channel)ctx.channel());
        if (center == null) {
            log.error("userEventTriggered: Unknown Center: [{}].", (Object)NettyUtils.getAddress((Channel)ctx.channel()));
            return;
        }
        if (!(e instanceof IdleStateEvent) || (evt = (IdleStateEvent)e).state() == IdleState.READER_IDLE) {
            // empty if block
        }
        ctx.fireUserEventTriggered(e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        EvpsCenter center = ApplicationRepository.getCenterObject((Channel)ctx.channel());
        if (center == null) {
            log.error("exceptionCaught: [{}]. {}.", (Object)NettyUtils.getAddress((Channel)ctx.channel()), (Object)cause.toString());
        } else {
            MDC.put((String)"id", (String)center.getLogKey());
            log.error("[{}]. exceptionCaught: [{}]. {}.", new Object[]{center.getLogKey(), center.getCenterId(), cause.toString()});
            MDC.remove((String)center.getLogKey());
            MDC.clear();
        }
        ctx.fireExceptionCaught(cause);
        ctx.channel().close();
    }

    public EvpsCommServerInboundMessageHandler(DataPacketProcess dataPacketProcess, DbmsDataProcess dbmsDataProcess) {
        this.dataPacketProcess = dataPacketProcess;
        this.dbmsDataProcess = dbmsDataProcess;
    }
}

