/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.xnet.server.process.response;

import com.evps.comm.server.kafka.KafkaProducerService;
import com.evps.comm.server.process.dbms.DbmsData;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.kafka.dto.EvpsSignalInfo;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.kafka.dto.KafkaEvpsSignalDto;
import com.evps.common.protocol.response.EvpsCommResponse;
import com.evps.common.protocol.response.RecvPacketDto;
import com.evps.common.utils.EvpsUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvpsSignal
implements EvpsCommResponse {
    private static final Logger log = LoggerFactory.getLogger(EvpsSignal.class);
    private final DbmsDataProcess dbmsDataProcess;
    private final KafkaProducerService kafkaProducerService;

    public boolean response(RecvPacketDto packet) {
        boolean result = true;
        try {
            log.info("[{}]. EvpsSignal.response. Service Id: {}.", (Object)packet.getCenter().getLogKey(), (Object)packet.getPacket().getServiceId());
            if (packet.getPacket().getCurrent() == 1 && packet.getPacket().getTotal() == 1) {
                return this.makeData(packet, packet.getPacket().getBuffer());
            }
            if (packet.getPacket().getCurrent() == 1) {
                packet.getCenter().clearSignalBuffer();
            }
            packet.getCenter().addSignalBuffer(packet.getPacket().getBuffer());
            if (packet.getPacket().getCurrent() == packet.getPacket().getTotal()) {
                log.info("[{}]. EvpsSignal.response: Service Id: {}, Recv All Frames. Sequence: Curr: ({}), Tot: ({})", new Object[]{packet.getCenter().getLogKey(), packet.getPacket().getServiceId(), packet.getPacket().getCurrent(), packet.getPacket().getTotal()});
                result = this.makeData(packet, packet.getCenter().getSignalBuffer().array());
                packet.getCenter().clearSignalBuffer();
            }
        }
        catch (Exception e) {
            log.error("[{}]. EvpsSignal.response: Service Id: {}, Exception. will be closed. {}", new Object[]{packet.getCenter().getLogKey(), packet.getPacket().getServiceId(), e.getMessage()});
            result = false;
        }
        return result;
    }

    private boolean makeData(RecvPacketDto packet, byte[] buffer) {
        KafkaEvpsServiceDto service;
        int nodeCount;
        int reqDataSize;
        EvpsCenter center = packet.getCenter();
        if (buffer == null || buffer.length < 2) {
            log.error("[{}]. EvpsSignal.response: Service Id: {}, Data Length Error: Required minimum data length({}), Cur({}). will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), 2, buffer == null ? 0 : buffer.length});
            return false;
        }
        String clctDt = EvpsUtils.getClctDt();
        String serviceId = packet.getPacket().getServiceId();
        int idx = 0;
        if (buffer.length - idx < (reqDataSize = 13 * (nodeCount = (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF))) {
            log.error("[{}]. EvpsSignal.response: Service Id: {}, Data Length Error: nodeCount({}), Required data length({}), Cur({}). will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), nodeCount, reqDataSize, buffer.length - idx});
            return false;
        }
        KafkaEvpsSignalDto signalDto = KafkaEvpsSignalDto.builder().serviceId(serviceId).clctDt(clctDt).signalList(new ArrayList()).build();
        for (int ii = 0; ii < nodeCount; ++ii) {
            long nodeId = (long)(buffer[idx++] & 0xFF) << 24 | (long)((buffer[idx++] & 0xFF) << 16) | (long)((buffer[idx++] & 0xFF) << 8) | (long)(buffer[idx++] & 0xFF);
            int remDist = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
            int state = buffer[idx++] & 0xFF;
            int planClass = buffer[idx++] & 0xFF;
            int aRingPhase = buffer[idx++] & 0xFF;
            int bRingPhase = buffer[idx++] & 0xFF;
            int holdPhase = buffer[idx++] & 0xFF;
            EvpsSignalInfo signal = EvpsSignalInfo.builder().serviceId(serviceId).clctDt(clctDt).nodeId(Long.valueOf(nodeId)).seqNo(Integer.valueOf(ii + 1)).remDist(Integer.valueOf(remDist)).state(Integer.valueOf(state)).planClass(Integer.valueOf(planClass)).aRingPhase(Integer.valueOf(aRingPhase)).bRingPhase(Integer.valueOf(bRingPhase)).holdPhase(Integer.valueOf(holdPhase)).build();
            signalDto.getSignalList().add(signal);
        }
        log.info("[{}]. EvpsSignal.response: Service Id: {}, Signal List {} EA.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), signalDto.getSignalList().size()});
        if (center.isDump()) {
            log.info("[{}]. EvpsSignal.response: Service Id: {}, Signal: {}.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), signalDto.getSignalList()});
        }
        if ((service = ApplicationRepository.getService((String)signalDto.getServiceId())) == null) {
            log.error("[{}]. EvpsSignal.response: Not Found Service Information. Service Id: {}", (Object)center.getLogKey(), (Object)signalDto.getServiceId());
        } else {
            service.updateLastCommTime();
        }
        if (!signalDto.getSignalList().isEmpty()) {
            this.kafkaProducerService.sendEvpsSignalTopic(signalDto);
            this.dbmsDataProcess.add(new DbmsData(16, center, (Object)signalDto));
        }
        return true;
    }

    public EvpsSignal(DbmsDataProcess dbmsDataProcess, KafkaProducerService kafkaProducerService) {
        this.dbmsDataProcess = dbmsDataProcess;
        this.kafkaProducerService = kafkaProducerService;
    }
}

