/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.xnet.client.codec;

import com.evps.comm.local.dto.CenterDto;
import com.evps.comm.local.repository.ApplicationRepository;
import com.its.common.network.NettyUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class EvpsLocalClientEncoder
extends MessageToByteEncoder<Object> {
    private static final Logger log = LoggerFactory.getLogger(EvpsLocalClientEncoder.class);

    protected void encode(ChannelHandlerContext ctx, Object msg, ByteBuf outByteBuf) {
        CenterDto center = ApplicationRepository.getCenterObject((Channel)ctx.channel());
        if (center == null) {
            log.error("SEND: [{}]. Not Found Channel Center Object... Oops Will be closed.", (Object)NettyUtils.getAddress((Channel)ctx.channel()));
            ApplicationRepository.closeChannel(null, (Channel)ctx.channel());
            return;
        }
        MDC.put((String)"id", (String)center.getLogKey());
        if (!(msg instanceof ByteBuffer)) {
            log.info("SEND: [{}, {}], Unknown Send Object type {}.", new Object[]{center.getLogKey(), center.getIpAddress(), msg.getClass().getName()});
            ApplicationRepository.closeChannel((CenterDto)center, (Channel)ctx.channel());
            return;
        }
        ByteBuffer buffer = (ByteBuffer)msg;
        outByteBuf.writeBytes(buffer.array());
        log.info("SEND: [{}, {}], {} Bytes.", new Object[]{center.getLogKey(), center.getIpAddress(), buffer.array().length});
        MDC.remove((String)center.getLogKey());
        MDC.clear();
    }
}

