/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.xnet.server;

import com.evps.comm.server.config.ApplicationConfig;
import com.evps.comm.server.entity.TbRegionCenterComm;
import com.evps.comm.server.process.dbms.DbmsData;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.comm.server.xnet.server.codec.EvpsSendByteBufMessageEncoder;
import com.evps.comm.server.xnet.server.handler.EvpsCommServerInboundMessageHandler;
import com.evps.common.dto.EvpsCenter;
import com.its.common.network.NettyUtils;
import com.its.common.spring.SpringUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class EvpsCommServerInitializer
extends ChannelInitializer<Channel> {
    private static final Logger log = LoggerFactory.getLogger(EvpsCommServerInitializer.class);
    private final EvpsCommServerInboundMessageHandler evpsCommServerInboundMessageHandler;
    private final EvpsSendByteBufMessageEncoder evpsSendByteBufMessageEncoder;
    private final ApplicationConfig config;
    private final ApplicationRepository appRepository;
    private final DbmsDataProcess dbmsDataProcess;

    public EvpsCommServerInitializer(ApplicationConfig config, ApplicationRepository applicationRepository, DbmsDataProcess dbmsDataProcess) {
        this.config = config;
        this.appRepository = applicationRepository;
        this.dbmsDataProcess = dbmsDataProcess;
        this.evpsCommServerInboundMessageHandler = (EvpsCommServerInboundMessageHandler)SpringUtils.getBean(EvpsCommServerInboundMessageHandler.class);
        this.evpsSendByteBufMessageEncoder = (EvpsSendByteBufMessageEncoder)SpringUtils.getBean(EvpsSendByteBufMessageEncoder.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initChannel(Channel channel) throws Exception {
        String ipAddress = NettyUtils.getRemoteIpAddress((Channel)channel);
        EvpsCenter center = this.appRepository.getIpAddrMap(ipAddress);
        if (center == null) {
            log.error("EvpsCommServerInitializer.----initChannel: {}, Unknown ip address. will be closed.", (Object)ipAddress);
            channel.disconnect();
            channel.close();
            return;
        }
        try {
            MDC.put((String)"id", (String)center.getLogKey());
            log.info("EvpsCommServerInitializer.----initChannel: {}, {},.", (Object)center.getCenterId(), (Object)ipAddress);
            if (center.getNetState().getChannel() != null) {
                log.warn("EvpsCommServerInitializer.----initChannel: {}, {}, Already Connected. Old Connection will be closed.", (Object)ipAddress, (Object)center.getCenterId());
                channel.attr(ApplicationRepository.SIG_REGION_ATTRIBUTE_KEY).set(null);
                center.getNetState().disConnect();
                channel.disconnect();
                channel.close();
            }
        }
        finally {
            MDC.remove((String)center.getLogKey());
            MDC.clear();
        }
        TbRegionCenterComm stts = TbRegionCenterComm.builder().centerId(center.getCenterId()).commState(0).opCode((byte)1).opCodeDesc("START").build();
        this.dbmsDataProcess.add(new DbmsData(1, center, (Object)stts));
        center.getNetState().connect(channel);
        channel.attr(ApplicationRepository.SIG_REGION_ATTRIBUTE_KEY).set((Object)center);
        IdleStateHandler idleStateHandler = new IdleStateHandler(this.config.getReaderIdleTimeSeconds(), 0, 0);
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO)});
        pipeline.addLast("idleStateHandler", (ChannelHandler)idleStateHandler);
        pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(32768, 35, 2, 0, 0));
        pipeline.addLast("packetInboundHandler", (ChannelHandler)this.evpsCommServerInboundMessageHandler);
        pipeline.addLast("frameEncoder", (ChannelHandler)this.evpsSendByteBufMessageEncoder);
    }
}

