/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.xnet.client;

import com.its.common.network.NettyUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvpsLocalClientBootstrapFactory {
    private static final Logger log = LoggerFactory.getLogger(EvpsLocalClientBootstrapFactory.class);
    private final int workerThread;
    private final int connectTimeout;
    private EventLoopGroup nioEventLoopGroup = null;

    public Bootstrap createBootstrap() {
        if (this.nioEventLoopGroup == null) {
            this.nioEventLoopGroup = NettyUtils.newEventLoopGroup((int)this.workerThread, (String)"vdsEventGroup");
        }
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(this.nioEventLoopGroup);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.AUTO_READ, (Object)true);
        bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
        bootstrap.option(ChannelOption.SO_RCVBUF, (Object)8192);
        bootstrap.option(ChannelOption.SO_SNDBUF, (Object)32768);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)false);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)(this.connectTimeout * 1000));
        return bootstrap;
    }

    public EventLoopGroup getEventLoopGroup() {
        return this.nioEventLoopGroup;
    }

    public void addChannelFuture(ChannelFuture future) {
    }

    public EvpsLocalClientBootstrapFactory(int workerThread, int connectTimeout) {
        this.workerThread = workerThread;
        this.connectTimeout = connectTimeout;
    }
}

