/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.config;

import com.its.common.network.tcp.server.NettyServerConfig;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="application")
public class ApplicationConfig
extends NettyServerConfig {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfig.class);
    private boolean loggingThread = false;
    private String processId = "evps-comm-server";
    private int autoEndMinutes = 20;
    private int lastCommTimeoutSeconds = 60;
    private int maxConnection = 0;
    private int packetWorkers = 0;
    private int loggingWorkers = 0;
    private int dbmsWorkers = 0;
    private int queueSize = 0;

    @PostConstruct
    private void init() {
        this.configure();
        if (this.packetWorkers == 0) {
            this.packetWorkers = Runtime.getRuntime().availableProcessors() / 2;
            if (this.packetWorkers == 0) {
                this.packetWorkers = 1;
            }
        }
        if (this.loggingWorkers == 0) {
            this.loggingWorkers = Runtime.getRuntime().availableProcessors() / 4;
            if (this.loggingWorkers == 0) {
                this.loggingWorkers = 1;
            }
        }
        if (this.dbmsWorkers == 0) {
            this.dbmsWorkers = Runtime.getRuntime().availableProcessors() / 4;
            if (this.dbmsWorkers == 0) {
                this.dbmsWorkers = 1;
            }
        }
        if (this.readerIdleTimeSeconds < 10) {
            this.readerIdleTimeSeconds = 12;
        }
        if (this.autoEndMinutes != 0) {
            if (this.autoEndMinutes < 10) {
                this.autoEndMinutes = 10;
            }
            if (this.autoEndMinutes > 60) {
                this.autoEndMinutes = 60;
            }
        }
        if (this.lastCommTimeoutSeconds < 20) {
            this.lastCommTimeoutSeconds = 20;
        }
        if (this.lastCommTimeoutSeconds > 180) {
            this.lastCommTimeoutSeconds = 180;
        }
        this.acceptThreads = 1;
        log.info("[{}] -------------------------", (Object)this.getClass().getSimpleName());
        log.info("[{}]         maxConnection: {}", (Object)this.getClass().getSimpleName(), (Object)this.maxConnection);
        log.info("[{}]         loggingThread: {}", (Object)this.getClass().getSimpleName(), (Object)this.loggingThread);
        log.info("[{}]         packetWorkers: {}", (Object)this.getClass().getSimpleName(), (Object)this.packetWorkers);
        log.info("[{}]        loggingWorkers: {}", (Object)this.getClass().getSimpleName(), (Object)this.loggingWorkers);
        log.info("[{}] readerIdleTimeSeconds: {}", (Object)this.getClass().getSimpleName(), (Object)this.readerIdleTimeSeconds);
        log.info("{}", (Object)super.toString());
    }

    public int getQueueSize() {
        int qSize = this.queueSize == 0 ? 1000 : this.queueSize;
        return qSize;
    }

    public boolean isLoggingThread() {
        return this.loggingThread;
    }

    public String getProcessId() {
        return this.processId;
    }

    public int getAutoEndMinutes() {
        return this.autoEndMinutes;
    }

    public int getLastCommTimeoutSeconds() {
        return this.lastCommTimeoutSeconds;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public int getPacketWorkers() {
        return this.packetWorkers;
    }

    public int getLoggingWorkers() {
        return this.loggingWorkers;
    }

    public int getDbmsWorkers() {
        return this.dbmsWorkers;
    }

    public void setLoggingThread(boolean loggingThread) {
        this.loggingThread = loggingThread;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setAutoEndMinutes(int autoEndMinutes) {
        this.autoEndMinutes = autoEndMinutes;
    }

    public void setLastCommTimeoutSeconds(int lastCommTimeoutSeconds) {
        this.lastCommTimeoutSeconds = lastCommTimeoutSeconds;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public void setPacketWorkers(int packetWorkers) {
        this.packetWorkers = packetWorkers;
    }

    public void setLoggingWorkers(int loggingWorkers) {
        this.loggingWorkers = loggingWorkers;
    }

    public void setDbmsWorkers(int dbmsWorkers) {
        this.dbmsWorkers = dbmsWorkers;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public String toString() {
        return "ApplicationConfig(loggingThread=" + this.isLoggingThread() + ", processId=" + this.getProcessId() + ", autoEndMinutes=" + this.getAutoEndMinutes() + ", lastCommTimeoutSeconds=" + this.getLastCommTimeoutSeconds() + ", maxConnection=" + this.getMaxConnection() + ", packetWorkers=" + this.getPacketWorkers() + ", loggingWorkers=" + this.getLoggingWorkers() + ", dbmsWorkers=" + this.getDbmsWorkers() + ", queueSize=" + this.getQueueSize() + ")";
    }
}

