/*
 * Decompiled with CFR 0.152.
 */
package com.evps.consumer.service;

import com.evps.common.kafka.dto.KafkaEvpsEventDto;
import com.evps.common.kafka.dto.KafkaEvpsNodeDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.kafka.dto.KafkaEvpsSignalDto;
import com.evps.consumer.service.KafkaConsumerWorker;
import com.evps.consumer.service.KafkaEvpsEventConsumerWorker;
import com.evps.consumer.service.KafkaEvpsNodeConsumerWorker;
import com.evps.consumer.service.KafkaEvpsServiceConsumerWorker;
import com.evps.consumer.service.KafkaEvpsSignalConsumerWorker;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.support.serializer.JsonDeserializer;

public class KafkaConsumerServiceOld {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerServiceOld.class);
    private final String bootstrapServers;
    private final String groupId;
    private ConcurrentMessageListenerContainer<String, String> kafkaListenerContainer;
    private ConcurrentMessageListenerContainer<String, KafkaEvpsServiceDto> serviceListenerContainer;
    private ConcurrentMessageListenerContainer<String, KafkaEvpsNodeDto> nodeListenerContainer;
    private ConcurrentMessageListenerContainer<String, KafkaEvpsSignalDto> signalListenerContainer;
    private ConcurrentMessageListenerContainer<String, KafkaEvpsEventDto> eventListenerContainer;

    public void start() {
        log.info("Starting Kafka Consumer: bootstrapServers: {}, group: {}", (Object)this.bootstrapServers, (Object)this.groupId);
        HashSet<String> topics = new HashSet<String>();
        topics.add("evps-service");
        topics.add("evps-node");
        topics.add("evps-signal");
        topics.add("evps-event");
        ContainerProperties containerProperties = new ContainerProperties(topics.toArray(new String[0]));
        containerProperties.setGroupId(this.groupId + "Z");
        containerProperties.setPollTimeout(5000L);
        containerProperties.setMessageListener((Object)new KafkaConsumerWorker());
        containerProperties.setConsumerRebalanceListener((ConsumerRebalanceListener)new /* Unavailable Anonymous Inner Class!! */);
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(this.getConsumerStringPropertiesMap());
        this.kafkaListenerContainer = new ConcurrentMessageListenerContainer((ConsumerFactory)consumerFactory, containerProperties);
        this.kafkaListenerContainer.setBeanName("consumer");
        this.kafkaListenerContainer.setConcurrency(1);
        this.kafkaListenerContainer.setErrorHandler((thrownException, data) -> {
            log.error("kafkaListenerContainer error: {}", (Object)thrownException.getMessage());
            this.kafkaListenerContainer.stop();
        });
        this.kafkaListenerContainer.start();
        ContainerProperties serviceContainerProperties = new ContainerProperties(new String[]{"evps-service"});
        serviceContainerProperties.setGroupId(this.groupId);
        serviceContainerProperties.setPollTimeout(5000L);
        serviceContainerProperties.setMessageListener((Object)new KafkaEvpsServiceConsumerWorker());
        serviceContainerProperties.setConsumerRebalanceListener((ConsumerRebalanceListener)new /* Unavailable Anonymous Inner Class!! */);
        DefaultKafkaConsumerFactory serviceFactory = new DefaultKafkaConsumerFactory(this.getConsumerPropertiesMap(), (Deserializer)new StringDeserializer(), (Deserializer)new JsonDeserializer(KafkaEvpsServiceDto.class, false));
        this.serviceListenerContainer = new ConcurrentMessageListenerContainer((ConsumerFactory)serviceFactory, serviceContainerProperties);
        this.serviceListenerContainer.setBeanName("serviceListenerContainer");
        this.serviceListenerContainer.setConcurrency(1);
        this.serviceListenerContainer.setErrorHandler((thrownException, data) -> {
            log.error("serviceListenerContainer error: {}", (Object)thrownException.getMessage());
            this.serviceListenerContainer.stop();
        });
        this.serviceListenerContainer.start();
        ContainerProperties nodeContainerProperties = new ContainerProperties(new String[]{"evps-node"});
        nodeContainerProperties.setGroupId(this.groupId);
        nodeContainerProperties.setPollTimeout(5000L);
        nodeContainerProperties.setMessageListener((Object)new KafkaEvpsNodeConsumerWorker());
        DefaultKafkaConsumerFactory nodeFactory = new DefaultKafkaConsumerFactory(this.getConsumerPropertiesMap());
        this.nodeListenerContainer = new ConcurrentMessageListenerContainer((ConsumerFactory)nodeFactory, nodeContainerProperties);
        this.nodeListenerContainer.setBeanName("nodeListenerContainer");
        this.nodeListenerContainer.setConcurrency(1);
        this.nodeListenerContainer.setErrorHandler((thrownException, data) -> {
            log.error("nodeListenerContainer error: {}", (Object)thrownException.getMessage());
            this.nodeListenerContainer.stop();
        });
        this.nodeListenerContainer.start();
        ContainerProperties signalContainerProperties = new ContainerProperties(new String[]{"evps-signal"});
        signalContainerProperties.setGroupId(this.groupId);
        signalContainerProperties.setPollTimeout(5000L);
        signalContainerProperties.setMessageListener((Object)new KafkaEvpsSignalConsumerWorker());
        DefaultKafkaConsumerFactory signalFactory = new DefaultKafkaConsumerFactory(this.getConsumerPropertiesMap());
        this.signalListenerContainer = new ConcurrentMessageListenerContainer((ConsumerFactory)signalFactory, signalContainerProperties);
        this.signalListenerContainer.setBeanName("signalListenerContainer");
        this.signalListenerContainer.setConcurrency(1);
        this.signalListenerContainer.setErrorHandler((thrownException, data) -> {
            log.error("signalListenerContainer error: {}", (Object)thrownException.getMessage());
            this.signalListenerContainer.stop();
        });
        this.signalListenerContainer.start();
        ContainerProperties eventContainerProperties = new ContainerProperties(new String[]{"evps-event"});
        eventContainerProperties.setGroupId(this.groupId);
        eventContainerProperties.setPollTimeout(5000L);
        eventContainerProperties.setMessageListener((Object)new KafkaEvpsEventConsumerWorker());
        DefaultKafkaConsumerFactory eventFactory = new DefaultKafkaConsumerFactory(this.getConsumerPropertiesMap());
        this.eventListenerContainer = new ConcurrentMessageListenerContainer((ConsumerFactory)eventFactory, eventContainerProperties);
        this.eventListenerContainer.setBeanName("eventListenerContainer");
        this.eventListenerContainer.setConcurrency(1);
        this.eventListenerContainer.setErrorHandler((thrownException, data) -> {
            log.error("eventListenerContainer error: {}", (Object)thrownException.getMessage());
            this.eventListenerContainer.stop();
        });
        this.eventListenerContainer.start();
    }

    public Map<String, Object> getConsumerPropertiesMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bootstrap.servers", this.bootstrapServers);
        properties.put("group.id", this.groupId);
        properties.put("enable.auto.commit", "true");
        properties.put("auto.commit.interval.ms", 1);
        properties.put("session.timeout.ms", "10000");
        properties.put("auto.offset.reset", "latest");
        properties.put("max.poll.interval.ms", "100");
        properties.put("check.crcs", false);
        properties.put("max.poll.records", 1);
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", JsonDeserializer.class);
        properties.put("spring.json.trusted.packages", "*");
        return properties;
    }

    public Map<String, Object> getConsumerStringPropertiesMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bootstrap.servers", this.bootstrapServers);
        properties.put("group.id", this.groupId);
        properties.put("enable.auto.commit", "true");
        properties.put("auto.commit.interval.ms", 1);
        properties.put("session.timeout.ms", "10000");
        properties.put("auto.offset.reset", "latest");
        properties.put("max.poll.interval.ms", "100");
        properties.put("check.crcs", false);
        properties.put("max.poll.records", 1);
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", StringDeserializer.class);
        properties.put("spring.json.trusted.packages", "*");
        return properties;
    }

    public void shutdown() {
        try {
            if (this.serviceListenerContainer != null) {
                this.serviceListenerContainer.stop();
            }
            if (this.nodeListenerContainer != null) {
                this.nodeListenerContainer.stop();
            }
            if (this.signalListenerContainer != null) {
                this.signalListenerContainer.stop();
            }
            if (this.eventListenerContainer != null) {
                this.eventListenerContainer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public KafkaConsumerServiceOld(String bootstrapServers, String groupId) {
        this.bootstrapServers = bootstrapServers;
        this.groupId = groupId;
    }
}

