/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.xnet.client.process.request;

import com.evps.comm.local.xnet.client.process.request.EvpsFrameData;
import com.evps.common.kafka.dto.EvpsSignalInfo;
import com.evps.common.kafka.dto.KafkaEvpsSignalDto;
import com.evps.common.protocol.eEvpsOpCode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EvpsSignal
extends EvpsFrameData {
    public EvpsSignal(KafkaEvpsSignalDto signal) {
        super(eEvpsOpCode.EVPS_SIGNAL.getValue(), signal.getServiceId());
        int signalList = signal.getSignalList().size();
        int bodySize = 2 + signalList * 13;
        this.body = ByteBuffer.allocate(bodySize);
        this.body.order(ByteOrder.BIG_ENDIAN);
        this.setLength(bodySize);
        this.body.putShort((short)(signalList & 0xFFFF));
        for (int ii = 0; ii < signalList; ++ii) {
            EvpsSignalInfo signalInfo = (EvpsSignalInfo)signal.getSignalList().get(ii);
            this.body.putInt((int)signalInfo.getNodeId().longValue());
            this.body.putInt(signalInfo.getRemDist());
            this.body.put(signalInfo.getState().byteValue());
            this.body.put(signalInfo.getPlanClass().byteValue());
            this.body.put(signalInfo.getARingPhase().byteValue());
            this.body.put(signalInfo.getBRingPhase().byteValue());
            this.body.put(signalInfo.getHoldPhase().byteValue());
        }
    }

    public String getMsgType() {
        return "EvpsSignal";
    }

    public ByteBuffer getByteBuffer() {
        ByteBuffer frame = ByteBuffer.allocate(this.getHeadSize() + this.getBodySize());
        frame.put(this.getHeadBuffer().array());
        frame.put(this.getBodyBuffer().array());
        return frame;
    }
}

