/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.controller;

import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.common.dto.EvpsCenter;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/info"})
public class EvpsCommServerController {
    private final ApplicationRepository repo;

    @GetMapping(value={""}, produces={"application/json; charset=utf8"})
    public String info() {
        String sep = System.lineSeparator();
        String heading = "---------------------------------------------------------------------------------------------------------";
        EvpsCenter center = ApplicationRepository.center;
        StringBuilder sb = new StringBuilder();
        sb.append(heading).append(sep);
        sb.append("UTIC EVPS Communication Server").append(sep);
        sb.append(heading).append(sep);
        sb.append(String.format("%s, %s", center.getCenterId(), center.getIpAddress() + sep));
        sb.append(heading).append(sep);
        sb.append(String.format("%s %-15.15s  %-8.8s %-20.20s %-20.20s %-20.20s Dump  %s", "Center", "IP Address", "Network", "Connect Time", "Disconnect Time", "Last Comm Time", "Center Name")).append(sep);
        sb.append(heading).append(sep);
        int total = 0;
        int onLine = 0;
        ArrayList keySet = new ArrayList(this.repo.getCenterMap().keySet());
        Collections.sort(keySet);
        for (String key : keySet) {
            EvpsCenter region = (EvpsCenter)this.repo.getCenterMap().get(key);
            if (region == null) continue;
            ++total;
            String commStatus = "Closed";
            if (region.getNetState().getState() != 0) {
                commStatus = "Connect";
                ++onLine;
            }
            sb.append(String.format("%-6s %-15s  %-8s %-20s %-20s %-20s %-5s %s", region.getCenterId(), region.getIpAddress(), commStatus, region.getNetState().getConnectTimeString(), region.getNetState().getDisconnectTimeString(), region.getNetState().getLastCommTimeString(), region.isDump(), region.getCenterNm())).append(sep);
        }
        sb.append(heading).append(sep);
        sb.append(String.format("Total : %d, OnLine(Connect): %d", total, onLine)).append(sep);
        sb.append(heading).append(sep);
        return sb.toString();
    }

    public EvpsCommServerController(ApplicationRepository repo) {
        this.repo = repo;
    }
}

