/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.server.xnet.server.process.response;

import com.evps.comm.server.kafka.KafkaProducerService;
import com.evps.comm.server.process.dbms.DbmsData;
import com.evps.comm.server.process.dbms.DbmsDataProcess;
import com.evps.comm.server.repository.ApplicationRepository;
import com.evps.common.dto.EvpsCenter;
import com.evps.common.kafka.dto.EvpsNodeInfo;
import com.evps.common.kafka.dto.EvpsPhaseInfo;
import com.evps.common.kafka.dto.KafkaEvpsNodeDto;
import com.evps.common.kafka.dto.KafkaEvpsPhaseDto;
import com.evps.common.kafka.dto.KafkaEvpsServiceDto;
import com.evps.common.protocol.response.EvpsCommResponse;
import com.evps.common.protocol.response.RecvPacketDto;
import com.evps.common.utils.EvpsByteUtils;
import com.evps.common.utils.EvpsUtils;
import com.its.common.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvpsNode
implements EvpsCommResponse {
    private static final Logger log = LoggerFactory.getLogger(EvpsNode.class);
    private final DbmsDataProcess dbmsDataProcess;
    private final KafkaProducerService kafkaProducerService;

    public boolean response(RecvPacketDto packet) {
        boolean result = true;
        try {
            log.info("[{}]. EvpsNode.response. Service Id: {}.", (Object)packet.getCenter().getLogKey(), (Object)packet.getPacket().getServiceId());
            if (packet.getPacket().getCurrent() == 1 && packet.getPacket().getTotal() == 1) {
                return this.makeData(packet, packet.getPacket().getBuffer());
            }
            if (packet.getPacket().getCurrent() == 1) {
                packet.getCenter().clearNodeBuffer();
            }
            packet.getCenter().addNodeBuffer(packet.getPacket().getBuffer());
            if (packet.getPacket().getCurrent() == packet.getPacket().getTotal()) {
                log.info("[{}]. EvpsNode.response: Service Id: {}, Recv All Frames. Sequence: Curr: ({}), Tot: ({})", new Object[]{packet.getCenter().getLogKey(), packet.getPacket().getServiceId(), packet.getPacket().getCurrent(), packet.getPacket().getTotal()});
                result = this.makeData(packet, packet.getCenter().getNodeBuffer().array());
                packet.getCenter().clearNodeBuffer();
            }
        }
        catch (Exception e) {
            log.error("[{}]. EvpsNode.response: Service Id: {}, Exception. will be closed. {}", new Object[]{packet.getCenter().getLogKey(), packet.getPacket().getServiceId(), e.getMessage()});
            result = false;
        }
        return result;
    }

    private boolean makeData(RecvPacketDto packet, byte[] buffer) {
        EvpsCenter center = packet.getCenter();
        if (buffer == null || buffer.length < 2) {
            log.error("[{}]. EvpsNode.response: Service Id: {}, Data Length Error: Required minimum data length({}), Cur({}). will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), 2, buffer == null ? 0 : buffer.length});
            return false;
        }
        String serviceId = packet.getPacket().getServiceId();
        int idx = 0;
        int nodeCount = (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
        log.info("[{}]. EvpsNode.response: Service Id: {}, nodeCount({}).", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), nodeCount});
        int reqDataSize = 114 * nodeCount;
        if (buffer.length - idx < reqDataSize) {
            log.error("[{}]. EvpsNode.response: Service Id: {}, Data Length Error: nodeCount({}), Required data length({}), Cur({}). will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), nodeCount, reqDataSize, buffer.length - idx});
            return false;
        }
        String clctDt = EvpsUtils.getClctDt();
        KafkaEvpsNodeDto nodeDto = KafkaEvpsNodeDto.builder().serviceId(serviceId).clctDt(clctDt).nodeList(new ArrayList()).build();
        KafkaEvpsPhaseDto phaseDto = KafkaEvpsPhaseDto.builder().serviceId(serviceId).clctDt(clctDt).phaseList(new ArrayList()).build();
        TimeUtils.sleep((long)200L);
        KafkaEvpsServiceDto service = ApplicationRepository.getService((String)nodeDto.getServiceId());
        if (service == null) {
            log.error("[{}]. EvpsNode.response: Service Id: {}, Not Found Service Information.", (Object)center.getLogKey(), (Object)nodeDto.getServiceId());
        } else {
            service.updateLastCommTime();
        }
        for (int ii = 0; ii < nodeCount; ++ii) {
            long nodeId = (long)(buffer[idx++] & 0xFF) << 24 | (long)((buffer[idx++] & 0xFF) << 16) | (long)((buffer[idx++] & 0xFF) << 8) | (long)(buffer[idx++] & 0xFF);
            byte[] nodeNmArr = Arrays.copyOfRange(buffer, idx, idx + 100);
            idx += 100;
            int currentLat = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
            int currentLng = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
            int seqNo = ii + 1;
            EvpsNodeInfo node = EvpsNodeInfo.builder().serviceId(nodeDto.getServiceId()).clctDt(clctDt).seqNo(Integer.valueOf(seqNo)).nodeId(Long.valueOf(nodeId)).nodeNm(EvpsByteUtils.toString((byte[])nodeNmArr)).lat((double)currentLat / 1000000.0).lng((double)currentLng / 1000000.0).phaseList(new ArrayList()).build();
            nodeDto.getNodeList().add(node);
            if (service != null) {
                service.getNodeList().add(node);
            }
            int phaseCount = (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
            log.info("[{}]. EvpsNode.response: Service Id: {}, node({}), phaseCount({}).", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), nodeId, phaseCount});
            int reqPhaseDataSize = 32 * phaseCount;
            if (buffer.length - idx < reqPhaseDataSize) {
                log.error("[{}]. EvpsNode.response: Service Id: {}, Phase Data Length Error: Required data length({}), Cur({}). will be closed.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), reqPhaseDataSize, buffer.length - idx});
                return false;
            }
            for (int jj = 0; jj < phaseCount; ++jj) {
                int ring = buffer[idx++] & 0xFF;
                int phaseNo = buffer[idx++] & 0xFF;
                int planClass = buffer[idx++] & 0xFF;
                int flowNo = buffer[idx++] & 0xFF;
                int headLat = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
                int headLng = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
                int midLat = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
                int midLng = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
                int endLat = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
                int endLng = (buffer[idx++] & 0xFF) << 24 | (buffer[idx++] & 0xFF) << 16 | (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
                int headAngle = (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
                int endAngle = (buffer[idx++] & 0xFF) << 8 | buffer[idx++] & 0xFF;
                EvpsPhaseInfo phase = EvpsPhaseInfo.builder().serviceId(nodeDto.getServiceId()).clctDt(clctDt).seqNo(Integer.valueOf(seqNo)).nodeId(Long.valueOf(nodeId)).ring(Integer.valueOf(ring)).phaseNo(Integer.valueOf(phaseNo)).planClass(Integer.valueOf(planClass)).flowNo(Integer.valueOf(flowNo)).headLat(Double.valueOf((double)headLat / 1000000.0)).headLng(Double.valueOf((double)headLng / 1000000.0)).midLat(Double.valueOf((double)midLat / 1000000.0)).midLng(Double.valueOf((double)midLng / 1000000.0)).endLat(Double.valueOf((double)endLat / 1000000.0)).endLng(Double.valueOf((double)endLng / 1000000.0)).headAngle(Integer.valueOf(headAngle)).endAngle(Integer.valueOf(endAngle)).build();
                node.getPhaseList().add(phase);
                phaseDto.getPhaseList().add(phase);
            }
        }
        log.info("[{}]. EvpsNode.response: Service Id: {}, Node List {} EA.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), nodeDto.getNodeList().size()});
        if (center.isDump()) {
            log.info("[{}]. EvpsNode.response: Service Id: {}, Node: {}.", new Object[]{center.getLogKey(), packet.getPacket().getServiceId(), nodeDto.getNodeList()});
        }
        if (!nodeDto.getNodeList().isEmpty()) {
            this.kafkaProducerService.sendEvpsNodeTopic(nodeDto);
            this.dbmsDataProcess.add(new DbmsData(14, center, (Object)nodeDto));
        }
        if (!phaseDto.getPhaseList().isEmpty()) {
            this.dbmsDataProcess.add(new DbmsData(15, center, (Object)phaseDto));
        }
        return true;
    }

    public EvpsNode(DbmsDataProcess dbmsDataProcess, KafkaProducerService kafkaProducerService) {
        this.dbmsDataProcess = dbmsDataProcess;
        this.kafkaProducerService = kafkaProducerService;
    }
}

