/*
 * Decompiled with CFR 0.152.
 */
package com.utic.its.asn1.asn1bean.ber.types;

import com.utic.its.asn1.asn1bean.ber.BerLength;
import com.utic.its.asn1.asn1bean.ber.BerTag;
import com.utic.its.asn1.asn1bean.ber.internal.Util;
import com.utic.its.asn1.asn1bean.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public class BerObjectIdentifier
implements Serializable,
BerType {
    public static final BerTag tag = new BerTag(0, 0, 6);
    private static final long serialVersionUID = 1L;
    public int[] value;
    private byte[] code = null;

    public BerObjectIdentifier() {
    }

    public BerObjectIdentifier(byte[] code) {
        this.code = code;
    }

    public BerObjectIdentifier(int[] value) {
        if (value.length < 2 || (value[0] == 0 || value[0] == 1) && value[1] > 39 || value[0] > 2) {
            throw new IllegalArgumentException("invalid object identifier components");
        }
        for (int objectIdentifierComponent : value) {
            if (objectIdentifierComponent >= 0) continue;
            throw new IllegalArgumentException("invalid object identifier components");
        }
        this.value = value;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int firstSubidentifier = 40 * this.value[0] + this.value[1];
        int codeLength = 0;
        for (int i = this.value.length - 1; i > 0; --i) {
            int subidentifier = i == 1 ? firstSubidentifier : this.value[i];
            int subIDLength = 1;
            while ((double)subidentifier > Math.pow(2.0, 7 * subIDLength) - 1.0) {
                ++subIDLength;
            }
            reverseOS.write(subidentifier & 0x7F);
            for (int j = 1; j <= subIDLength - 1; ++j) {
                reverseOS.write(subidentifier >> 7 * j & 0xFF | 0x80);
            }
            codeLength += subIDLength;
        }
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int i;
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        if (length.val == 0) {
            this.value = new int[0];
            return codeLength;
        }
        byte[] byteCode = new byte[length.val];
        Util.readFully(is, byteCode);
        codeLength += length.val;
        ArrayList<Integer> objectIdentifierComponentsList = new ArrayList<Integer>();
        int subIDEndIndex = 0;
        while ((byteCode[subIDEndIndex] & 0x80) == 128) {
            if (subIDEndIndex >= length.val - 1) {
                throw new IOException("Invalid Object Identifier");
            }
            ++subIDEndIndex;
        }
        int subidentifier = 0;
        for (i = 0; i <= subIDEndIndex; ++i) {
            subidentifier |= (byteCode[i] & 0x7F) << (subIDEndIndex - i) * 7;
        }
        if (subidentifier < 40) {
            objectIdentifierComponentsList.add(0);
            objectIdentifierComponentsList.add(subidentifier);
        } else if (subidentifier < 80) {
            objectIdentifierComponentsList.add(1);
            objectIdentifierComponentsList.add(subidentifier - 40);
        } else {
            objectIdentifierComponentsList.add(2);
            objectIdentifierComponentsList.add(subidentifier - 80);
        }
        ++subIDEndIndex;
        while (subIDEndIndex < length.val) {
            int subIDStartIndex = subIDEndIndex;
            while ((byteCode[subIDEndIndex] & 0x80) == 128) {
                if (subIDEndIndex == length.val - 1) {
                    throw new IOException("Invalid Object Identifier");
                }
                ++subIDEndIndex;
            }
            subidentifier = 0;
            for (int j = subIDStartIndex; j <= subIDEndIndex; ++j) {
                subidentifier |= (byteCode[j] & 0x7F) << (subIDEndIndex - j) * 7;
            }
            objectIdentifierComponentsList.add(subidentifier);
            ++subIDEndIndex;
        }
        this.value = new int[objectIdentifierComponentsList.size()];
        for (i = 0; i < objectIdentifierComponentsList.size(); ++i) {
            this.value[i] = (Integer)objectIdentifierComponentsList.get(i);
        }
        return codeLength;
    }

    public String toString() {
        if (this.value == null || this.value.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(Integer.toString(this.value[0]));
        for (int i = 1; i < this.value.length; ++i) {
            sb.append(".").append(this.value[i]);
        }
        return sb.toString();
    }
}

