/*
 * Decompiled with CFR 0.152.
 */
package com.utic.its.asn1.asn1bean.ber.types;

import com.utic.its.asn1.asn1bean.ber.BerLength;
import com.utic.its.asn1.asn1bean.ber.BerTag;
import com.utic.its.asn1.asn1bean.ber.internal.Util;
import com.utic.its.asn1.asn1bean.ber.types.BerType;
import com.utic.its.asn1.asn1bean.util.HexString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class BerOctetString
implements Serializable,
BerType {
    public static final BerTag tag = new BerTag(0, 0, 4);
    private static final long serialVersionUID = 1L;
    public byte[] value;

    public BerOctetString() {
    }

    public BerOctetString(byte[] value) {
        this.value = value;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        reverseOS.write(this.value);
        int codeLength = this.value.length;
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        this.value = new byte[length.val];
        if (length.val != 0) {
            Util.readFully(is, this.value);
            codeLength += length.val;
        }
        return codeLength;
    }

    public String toString() {
        return HexString.fromBytes(this.value);
    }
}

