/*
 * Decompiled with CFR 0.152.
 */
package com.utic.its.asn1.its;

import com.utic.its.asn1.asn1bean.ber.BerLength;
import com.utic.its.asn1.asn1bean.ber.BerTag;
import com.utic.its.asn1.asn1bean.ber.ReverseByteArrayOutputStream;
import com.utic.its.asn1.asn1bean.ber.types.BerInteger;
import com.utic.its.asn1.asn1bean.ber.types.BerNull;
import com.utic.its.asn1.asn1bean.ber.types.BerObjectIdentifier;
import com.utic.its.asn1.asn1bean.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class Accept
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(0, 32, 16);
    private byte[] code = null;
    private BerInteger datexAcceptPacketNbr = null;
    private DatexAcceptType datexAcceptType = null;

    public Accept() {
    }

    public Accept(byte[] code) {
        this.code = code;
    }

    public void setDatexAcceptPacketNbr(BerInteger datexAcceptPacketNbr) {
        this.datexAcceptPacketNbr = datexAcceptPacketNbr;
    }

    public BerInteger getDatexAcceptPacketNbr() {
        return this.datexAcceptPacketNbr;
    }

    public void setDatexAcceptType(DatexAcceptType datexAcceptType) {
        this.datexAcceptType = datexAcceptType;
    }

    public DatexAcceptType getDatexAcceptType() {
        return this.datexAcceptType;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        int sublength = this.datexAcceptType.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength(reverseOS, sublength);
        reverseOS.write(161);
        ++codeLength;
        codeLength += this.datexAcceptPacketNbr.encode(reverseOS, false);
        reverseOS.write(128);
        ++codeLength;
        codeLength += BerLength.encodeLength(reverseOS, codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.datexAcceptPacketNbr = new BerInteger();
            vByteCount += this.datexAcceptPacketNbr.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (berTag.equals(128, 32, 1)) {
            vByteCount += length.decode(is);
            this.datexAcceptType = new DatexAcceptType();
            vByteCount += this.datexAcceptType.decode(is, null);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte(is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.datexAcceptPacketNbr != null) {
            sb.append("datexAcceptPacketNbr: ").append(this.datexAcceptPacketNbr);
        } else {
            sb.append("datexAcceptPacketNbr: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.datexAcceptType != null) {
            sb.append("datexAcceptType: ");
            this.datexAcceptType.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("datexAcceptType: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class DatexAcceptType
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private BerObjectIdentifier logIn = null;
        private BerNull singleSubscription = null;
        private BerInteger registeredSubscription = null;
        private BerNull publication = null;

        public DatexAcceptType() {
        }

        public DatexAcceptType(byte[] code) {
            this.code = code;
        }

        public void setLogIn(BerObjectIdentifier logIn) {
            this.logIn = logIn;
        }

        public BerObjectIdentifier getLogIn() {
            return this.logIn;
        }

        public void setSingleSubscription(BerNull singleSubscription) {
            this.singleSubscription = singleSubscription;
        }

        public BerNull getSingleSubscription() {
            return this.singleSubscription;
        }

        public void setRegisteredSubscription(BerInteger registeredSubscription) {
            this.registeredSubscription = registeredSubscription;
        }

        public BerInteger getRegisteredSubscription() {
            return this.registeredSubscription;
        }

        public void setPublication(BerNull publication) {
            this.publication = publication;
        }

        public BerNull getPublication() {
            return this.publication;
        }

        @Override
        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                return this.code.length;
            }
            int codeLength = 0;
            if (this.publication != null) {
                codeLength += this.publication.encode(reverseOS, false);
                reverseOS.write(131);
                return ++codeLength;
            }
            if (this.registeredSubscription != null) {
                codeLength += this.registeredSubscription.encode(reverseOS, false);
                reverseOS.write(130);
                return ++codeLength;
            }
            if (this.singleSubscription != null) {
                codeLength += this.singleSubscription.encode(reverseOS, false);
                reverseOS.write(129);
                return ++codeLength;
            }
            if (this.logIn != null) {
                codeLength += this.logIn.encode(reverseOS, false);
                reverseOS.write(128);
                return ++codeLength;
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        @Override
        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            boolean tagWasPassed;
            int tlvByteCount = 0;
            boolean bl = tagWasPassed = berTag != null;
            if (berTag == null) {
                berTag = new BerTag();
                tlvByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 0)) {
                this.logIn = new BerObjectIdentifier();
                return tlvByteCount += this.logIn.decode(is, false);
            }
            if (berTag.equals(128, 0, 1)) {
                this.singleSubscription = new BerNull();
                return tlvByteCount += this.singleSubscription.decode(is, false);
            }
            if (berTag.equals(128, 0, 2)) {
                this.registeredSubscription = new BerInteger();
                return tlvByteCount += this.registeredSubscription.decode(is, false);
            }
            if (berTag.equals(128, 0, 3)) {
                this.publication = new BerNull();
                return tlvByteCount += this.publication.decode(is, false);
            }
            if (tagWasPassed) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode(reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.logIn != null) {
                sb.append("logIn: ").append(this.logIn);
                return;
            }
            if (this.singleSubscription != null) {
                sb.append("singleSubscription: ").append(this.singleSubscription);
                return;
            }
            if (this.registeredSubscription != null) {
                sb.append("registeredSubscription: ").append(this.registeredSubscription);
                return;
            }
            if (this.publication != null) {
                sb.append("publication: ").append(this.publication);
                return;
            }
            sb.append("<none>");
        }
    }
}

